/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.annotations;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.ChunkHandler;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.annotations.Early;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.preconditions.Description;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.acteurbase.Deferral;
import com.mastfrog.giulius.Dependencies;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import javax.inject.Inject;

@Description(value="Installs the chunk handler for unprocessed HTTP content")
public class InstallChunkHandler
extends Acteur {
    @Inject
    InstallChunkHandler(Page page, Deferral defer, HttpEvent evt, Dependencies deps, ApplicationControl ctrl) {
        Object[] inject = new Object[]{};
        if (Method.POST.equals((Object)evt.method()) || Method.PUT.equals((Object)evt.method()) || HttpMethod.PATCH.equals((Object)evt.method())) {
            ChannelHandlerContext ctx = evt.ctx();
            Early early = page.getClass().getAnnotation(Early.class);
            if (early == null) {
                ctrl.internalOnError(new IllegalStateException("Should not be instantiated for a page without the @Early annotation.  Stale sources?"));
            }
            if (early.value() != ChunkHandler.class) {
                ChunkHandler ch = (ChunkHandler)((Object)deps.getInstance(early.value()));
                ctx.pipeline().addAfter("early", ((Object)((Object)ch)).getClass().getSimpleName(), (ChannelHandler)ch);
                defer.defer(ch::setResumer);
            }
            if (early.send100continue()) {
                InstallChunkHandler.send100Continue(ctx);
            }
        }
        this.next(inject);
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }
}

