/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.auth;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.auth.AsyncAuthenticator;
import com.mastfrog.acteur.auth.AuthenticationActeur;
import com.mastfrog.acteur.auth.AuthenticationResult;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.preconditions.Authenticated;
import com.mastfrog.acteur.util.RequestID;
import com.mastfrog.acteurbase.Chain;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;

final class AsyncAuthenticationActeur
extends AuthenticationActeur {
    private static final HeaderValueType<CharSequence> VT = Headers.header((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE);
    private static final AsciiString BEARER = new AsciiString((CharSequence)"Bearer");

    @Inject
    AsyncAuthenticationActeur(AsyncAuthenticator<?> auth, Chain chain, HttpEvent evt, RequestID rid, Page page) {
        String authHeader = evt.header((CharSequence)HttpHeaderNames.AUTHORIZATION);
        String scheme = "bearer ";
        if (authHeader == null) {
            Authenticated anno = page.getClass().getAnnotation(Authenticated.class);
            if (anno != null) {
                switch (anno.value()) {
                    case "default": 
                    case "optional": {
                        break;
                    }
                    default: {
                        scheme = anno.value() + " ";
                    }
                }
            }
            if (anno == null || !"optional".equals(anno.value()) || !anno.optional()) {
                this.reply(HttpResponseStatus.UNAUTHORIZED, "No auth header present");
                return;
            }
            if ("optional".equals(anno.value()) || anno.optional()) {
                this.next(new Object[0]);
                return;
            }
        }
        if (!Strings.startsWithIgnoreCase((CharSequence)authHeader, (CharSequence)scheme)) {
            this.reply(HttpResponseStatus.UNAUTHORIZED, "Invalid auth header prefix in '" + authHeader + "'");
            return;
        }
        String token = Strings.urlDecode((String)authHeader.substring(scheme.length()));
        String invalidMessage = auth.validate(evt, token);
        if (invalidMessage != null) {
            this.reply(HttpResponseStatus.UNAUTHORIZED, invalidMessage);
            this.add(VT, scheme.trim());
            return;
        }
        chain.insert(CheckAuth.class);
        this.continueAfter(true, new CompletionStage[]{auth.authenticate(rid, evt, token)});
    }

    static final class CheckAuth
    extends Acteur {
        @Inject
        CheckAuth(AuthenticationResult<?> authRes, Page page) {
            Authenticated anno = page.getClass().getAnnotation(Authenticated.class);
            if (anno != null && "optional".equals(anno.value())) {
                this.next(new Object[0]);
                return;
            }
            if (authRes.failureStatus != null) {
                this.add(VT, BEARER);
                if (authRes.failureMessage != null) {
                    this.reply(authRes.failureStatus, authRes.failureMessage);
                } else {
                    this.reply(authRes.failureStatus);
                }
                return;
            }
            this.next(authRes, authRes.info);
        }
    }
}

