/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.auth;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Providers;
import com.mastfrog.acteur.auth.AsyncAuthenticationActeur;
import com.mastfrog.acteur.auth.AsyncAuthenticator;
import com.mastfrog.acteur.auth.AuthenticationActeur;
import com.mastfrog.acteur.auth.AuthenticationResult;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.giulius.util.TypeUtils;
import java.lang.reflect.Type;
import javax.inject.Inject;

public class AsyncAuthenticationModule<AuthInfoType>
extends AbstractModule {
    private final Class<? extends AuthInfoType> infoType;
    private final Class<? extends AsyncAuthenticator<AuthInfoType>> authenticatorType;
    private final ReentrantScope scope;

    public AsyncAuthenticationModule(Class<? extends AuthInfoType> infoType, Class<? extends AsyncAuthenticator<AuthInfoType>> authenticatorType, ReentrantScope scope) {
        this.infoType = infoType;
        this.authenticatorType = authenticatorType;
        this.scope = scope;
    }

    protected void configure() {
        this.scope.bindTypesAllowingNulls(this.binder(), new Class[]{this.infoType});
        this.bind(AuthenticationActeur.class).to(AsyncAuthenticationActeur.class);
        this.bind(new TypeLiteral<AsyncAuthenticator<?>>(){}).to(this.authenticatorType);
        Key key = Key.get((Type)TypeUtils.generifiedType(AuthenticationResult.class, this.infoType));
        Provider p = this.scope.scope(key, Providers.of(null));
        this.bind(key).toProvider(p);
        this.bind(new TypeLiteral<AsyncAuthenticator<?>>(){}).to(this.authenticatorType);
        this.bind(new TypeLiteral<AuthenticationResult<?>>(){}).toProvider((Provider)new ParameterizedAuthProvider(p));
    }

    static final class ParameterizedAuthProvider
    implements Provider<AuthenticationResult<?>> {
        private final Provider<? extends AuthenticationResult<?>> resProvider;

        @Inject
        public ParameterizedAuthProvider(Provider<? extends AuthenticationResult<?>> resProvider) {
            this.resProvider = resProvider;
        }

        public AuthenticationResult<?> get() {
            return (AuthenticationResult)this.resProvider.get();
        }
    }
}

