/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.auth;

import com.google.inject.ImplementedBy;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.Response;
import com.mastfrog.acteur.auth.AuthenticationActeur;
import com.mastfrog.acteur.auth.Authenticator;
import com.mastfrog.acteur.auth.Tarpit;
import com.mastfrog.acteur.header.entities.BasicCredentials;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.util.Realm;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.perf.Benchmark;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import javax.inject.Inject;

@Deprecated
public class AuthenticateBasicActeur
extends AuthenticationActeur {
    public static final String SETTINGS_KEY_TARPIT_BAD_LOGIN_ATTEMPT_COUNT = "max.allowed.failed.login.attempts";
    public static final String SETTINGS_KEY_TARPIT_DELAY_RESPONSE_AFTER = "delay.failed.login.attempts.after";
    public static final String SETTINGS_KEY_TARPIT_DELAY_SECONDS = "failed.login.attempt.response.delay";
    public static final int DEFAULT_FAILED_LOGIN_ATTEMPT_LIMIT = 7;
    public static final int DEFAULT_FAILED_LOGIN_ATTEMPT_DELAY_THRESHOLD = 3;
    public static final int DEFAULT_FAILED_LOGIN_DELAY_SECONDS_MULTIPLIER = 1;

    @Inject
    AuthenticateBasicActeur(HttpEvent event, Authenticator authenticator, Realm r, Tarpit tarpit, Settings settings, AuthenticationDecorator decorator, Page page) throws IOException {
        int badRequestCount = tarpit.count(event);
        if (badRequestCount > 0 && badRequestCount > settings.getInt(SETTINGS_KEY_TARPIT_BAD_LOGIN_ATTEMPT_COUNT, 7)) {
            this.setState((Acteur)this.new Acteur.RespondWith(HttpResponseStatus.SERVICE_UNAVAILABLE, (Object)"Too many bad password attempts"));
            return;
        }
        BasicCredentials credentials = (BasicCredentials)event.header(Headers.AUTHORIZATION);
        if (credentials == null) {
            this.unauthorized(r, event, decorator, page, this.response());
        } else {
            Object[] stuff = authenticator.authenticate(r.toString(), credentials);
            if (stuff == null) {
                int badCount = tarpit.add(event);
                if (badCount > settings.getInt(SETTINGS_KEY_TARPIT_DELAY_RESPONSE_AFTER, 3)) {
                    this.delayResponse(badCount, settings);
                }
                this.unauthorized(r, event, decorator, page, this.response());
            } else {
                decorator.onAuthenticationSucceeded(event, page, this.response(), stuff);
                this.next(stuff);
            }
        }
    }

    @Benchmark(value="tarpittedClients", publish={Benchmark.Kind.CALL_COUNT})
    void delayResponse(int badCount, Settings settings) {
        Duration delayResponse = Duration.ofSeconds(badCount * settings.getInt(SETTINGS_KEY_TARPIT_DELAY_SECONDS, 1));
        this.response().delayedBy(delayResponse);
    }

    @Benchmark(value="failedAuthentication", publish={Benchmark.Kind.CALL_COUNT})
    private void unauthorized(Realm realm, HttpEvent evt, AuthenticationDecorator decorator, Page page, Response response) {
        decorator.onAuthenticationFailed(evt, page, response);
        this.add(Headers.WWW_AUTHENTICATE, realm);
        this.setState((Acteur)this.new Acteur.RespondWith(HttpResponseStatus.UNAUTHORIZED));
        this.setResponseBodyWriter(ChannelFutureListener.CLOSE);
    }

    @Override
    public void describeYourself(Map<String, Object> into) {
        into.put("Basic Authentication Required", true);
    }

    @ImplementedBy(value=NoOpDecorator.class)
    public static interface AuthenticationDecorator {
        public void onAuthenticationSucceeded(HttpEvent var1, Page var2, Response var3, Object[] var4);

        public void onAuthenticationFailed(HttpEvent var1, Page var2, Response var3);
    }

    private static class NoOpDecorator
    implements AuthenticationDecorator {
        private NoOpDecorator() {
        }

        @Override
        public void onAuthenticationSucceeded(HttpEvent evt, Page page, Response response, Object[] stuff) {
        }

        @Override
        public void onAuthenticationFailed(HttpEvent evt, Page page, Response response) {
        }
    }
}

