/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.auth;

import io.netty.handler.codec.http.HttpResponseStatus;

public final class AuthenticationResult<T> {
    public final T info;
    public final HttpResponseStatus failureStatus;
    public final String failureMessage;
    public final String token;

    public AuthenticationResult(T info, String token) {
        this(info, null, null, token);
    }

    public AuthenticationResult(String failureMessage) {
        this(null, HttpResponseStatus.UNAUTHORIZED, failureMessage, null);
    }

    public AuthenticationResult(String failureMessage, String token) {
        this(null, HttpResponseStatus.UNAUTHORIZED, failureMessage, token);
    }

    public AuthenticationResult(HttpResponseStatus status, String failureMessage, String token) {
        this(null, status, failureMessage, token);
    }

    public AuthenticationResult(HttpResponseStatus status, String failureMessage) {
        this(null, status, failureMessage, null);
    }

    public boolean isAuthenticated() {
        return this.info != null && this.failureMessage == null;
    }

    public AuthenticationResult(T info, HttpResponseStatus failureStatus, String failureMessage, String token) {
        this.info = info;
        this.failureStatus = failureStatus;
        this.failureMessage = failureMessage;
        this.token = token;
    }
}

