/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.auth;

import com.google.inject.Singleton;
import com.mastfrog.acteur.auth.Authenticator;
import com.mastfrog.acteur.header.entities.BasicCredentials;
import com.mastfrog.acteur.util.PasswordHasher;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.preconditions.ConfigurationError;
import java.io.IOException;
import javax.inject.Inject;

@Singleton
final class MockAuthenticator
implements Authenticator {
    private final String mockPassword;
    private final PasswordHasher hasher;

    @Inject
    MockAuthenticator(Settings settings, PasswordHasher hasher) {
        this.hasher = hasher;
        this.mockPassword = hasher.encryptPassword(settings.getString("mockPassword", "password"));
        if (Dependencies.isProductionMode((Settings)settings)) {
            throw new ConfigurationError("Using mock " + this.getClass().getName() + " in production");
        }
    }

    @Override
    public Object[] authenticate(String realm, BasicCredentials credentials) throws IOException {
        if (this.hasher.checkPassword(credentials.password, this.mockPassword)) {
            return new Object[]{credentials};
        }
        return null;
    }
}

