/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.auth;

import java.util.Objects;

public interface SimpleUser<IdType> {
    public String name();

    public int version();

    public IdType id();

    public String idAsString();

    public String displayName();

    public static class Base<T>
    implements SimpleUser<T> {
        private final String name;
        private final int version;
        private final T id;
        private final String displayName;

        public Base(String name, int version, T id) {
            this(name, version, id, null);
        }

        public Base(String name, int version, T id, String displayName) {
            this.name = name;
            this.version = version;
            this.id = id;
            this.displayName = displayName;
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final int version() {
            return this.version;
        }

        @Override
        public final T id() {
            return this.id;
        }

        @Override
        public String idAsString() {
            return Objects.toString(this.id);
        }

        @Override
        public final String displayName() {
            return this.displayName == null ? this.name : this.displayName;
        }

        public final boolean equals(Object o) {
            return o instanceof SimpleUser && this.id.equals(((SimpleUser)o).id());
        }

        public final int hashCode() {
            return Objects.hashCode(this.id);
        }

        public String toString() {
            return this.name + " (" + this.id + ")";
        }
    }
}

