/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.auth;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.auth.Tarpit;
import com.mastfrog.acteur.auth.TarpitCacheKeyFactory;
import com.mastfrog.settings.Settings;
import com.mastfrog.shutdown.hooks.ShutdownHookRegistry;
import com.mastfrog.util.time.TimeUtil;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.inject.Inject;

@Singleton
final class TarpitImpl
implements Tarpit {
    private final Map<String, Entry> map = Maps.newConcurrentMap();
    private final Duration timeToExpiration;
    private final TarpitCacheKeyFactory keyFactory;
    private final GarbageCollect gc = new GarbageCollect();

    @Inject
    TarpitImpl(Settings settings, TarpitCacheKeyFactory keyFactory, ShutdownHookRegistry reg) {
        this.timeToExpiration = Duration.ofMinutes(settings.getLong("tarpit.default.expiration.minutes", 5L));
        Timer timer = new Timer(true);
        Date firstTime = new Date(TimeUtil.toUnixTimestamp((ZonedDateTime)ZonedDateTime.now().plus(this.timeToExpiration)));
        timer.scheduleAtFixedRate((TimerTask)this.gc, firstTime, this.timeToExpiration.toMillis() / 2L);
        reg.add(new Runnable(){

            @Override
            public void run() {
                TarpitImpl.this.gc.cancel();
            }
        });
        this.keyFactory = keyFactory;
    }

    @Override
    public int count(HttpEvent evt) {
        Entry e = this.map.get(this.keyFactory.createKey(evt));
        int result = e == null ? 0 : e.size();
        return result;
    }

    int garbageCollect() {
        HashMap<String, Entry> copy = new HashMap<String, Entry>(this.map);
        int result = 0;
        for (Map.Entry e : copy.entrySet()) {
            if (!((Entry)e.getValue()).isExpired()) continue;
            this.map.remove(e.getKey());
            ++result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(HttpEvent evt) {
        String remoteAddress = this.keyFactory.createKey(evt);
        Entry entry = this.map.get(remoteAddress);
        if (entry == null) {
            Map<String, Entry> map = this.map;
            synchronized (map) {
                entry = this.map.get(remoteAddress);
                if (entry == null) {
                    entry = new Entry();
                    this.map.put(remoteAddress, entry);
                } else {
                    entry.touch();
                }
            }
        } else {
            entry.touch();
        }
        return entry.touch();
    }

    @Override
    public void remove(HttpEvent evt) {
        this.map.remove(this.keyFactory.createKey(evt));
    }

    private class GarbageCollect
    extends TimerTask {
        private GarbageCollect() {
        }

        @Override
        public void run() {
            TarpitImpl.this.garbageCollect();
        }
    }

    private class Entry {
        ConcurrentLinkedDeque<Long> accesses = new ConcurrentLinkedDeque();

        private Entry() {
        }

        int touch() {
            this.accesses.offerLast(System.currentTimeMillis());
            return this.accesses.size();
        }

        int size() {
            return this.accesses.size();
        }

        boolean isExpired() {
            ZonedDateTime now = ZonedDateTime.now();
            Iterator<Long> iter = this.accesses.iterator();
            while (iter.hasNext()) {
                ZonedDateTime when = TimeUtil.fromUnixTimestamp((long)iter.next());
                Duration dur = Duration.between(when, now);
                if (!TimeUtil.isLonger((Duration)dur, (Duration)TarpitImpl.this.timeToExpiration)) continue;
                iter.remove();
            }
            return this.accesses.isEmpty();
        }

        public String toString() {
            return this.accesses.toString() + " expired " + this.isExpired();
        }
    }
}

