/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.debug;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.debug.Probe;
import com.mastfrog.acteur.util.RequestID;
import com.mastfrog.acteurbase.ActeurState;
import io.netty.handler.codec.http.HttpResponseStatus;
import javax.inject.Provider;

public abstract class HttpProbe
implements Provider<Probe> {
    private final ProbeImpl probe = new ProbeImpl();
    private boolean enabled = true;

    protected void onBeforeProcessRequest(RequestID id, HttpEvent req) {
    }

    protected void onBeforeRunPage(RequestID id, HttpEvent evt, Page page) {
    }

    protected void onActeurWasRun(RequestID id, HttpEvent evt, Page page, Acteur acteur, ActeurState result) {
    }

    protected void onFallthrough(RequestID id, HttpEvent evt) {
    }

    protected void onBeforeSendResponse(RequestID id, HttpEvent httpEvent, Acteur acteur, HttpResponseStatus status, boolean hasListener, Object message) {
    }

    protected void onInfo(String info, Object ... objs) {
    }

    protected void onThrown(RequestID id, HttpEvent evt, Throwable thrown) {
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    public final Probe get() {
        return this.probe;
    }

    class ProbeImpl
    implements Probe {
        ProbeImpl() {
        }

        @Override
        public void onBeforeProcessRequest(RequestID id, Event<?> req) {
            if (req instanceof HttpEvent && HttpProbe.this.isEnabled()) {
                HttpProbe.this.onBeforeProcessRequest(id, (HttpEvent)req);
            }
        }

        @Override
        public void onBeforeRunPage(RequestID id, Event<?> evt, Page page) {
            if (evt instanceof HttpEvent && HttpProbe.this.isEnabled()) {
                HttpProbe.this.onBeforeRunPage(id, (HttpEvent)evt, page);
            }
        }

        @Override
        public void onActeurWasRun(RequestID id, Event<?> evt, Page page, Acteur acteur, ActeurState result) {
            if (evt instanceof HttpEvent && HttpProbe.this.isEnabled()) {
                HttpProbe.this.onActeurWasRun(id, (HttpEvent)evt, page, acteur, result);
            }
        }

        @Override
        public void onFallthrough(RequestID id, Event<?> evt) {
            if (evt instanceof HttpEvent && HttpProbe.this.isEnabled()) {
                HttpProbe.this.onFallthrough(id, (HttpEvent)evt);
            }
        }

        @Override
        public void onBeforeSendResponse(RequestID id, Event<?> event, Acteur acteur, HttpResponseStatus status, boolean hasListener, Object message) {
            if (event instanceof HttpEvent && HttpProbe.this.isEnabled()) {
                HttpProbe.this.onBeforeSendResponse(id, (HttpEvent)event, acteur, status, hasListener, message);
            }
        }

        @Override
        public void onInfo(String info, Object ... objs) {
            if (HttpProbe.this.isEnabled()) {
                HttpProbe.this.onInfo(info, objs);
            }
        }

        @Override
        public void onThrown(RequestID id, Event<?> evt, Throwable thrown) {
            if (evt instanceof HttpEvent && HttpProbe.this.isEnabled()) {
                HttpProbe.this.onThrown(id, (HttpEvent)evt, thrown);
            }
        }
    }
}

