/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.errors;

import com.google.common.collect.ImmutableMap;
import com.mastfrog.acteur.errors.ErrorResponse;
import com.mastfrog.acteur.errors.ResponseException;
import com.mastfrog.util.preconditions.Checks;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Err
implements ErrorResponse {
    public final HttpResponseStatus status;
    public final Map<String, Object> message;
    private Map<CharSequence, CharSequence> headers;
    public boolean unhandled;

    public Err(Throwable t, boolean unhandled) {
        this(t);
        this.unhandled = unhandled;
    }

    public Err(Throwable t) {
        this(Err.unwind(t, true));
    }

    @Override
    public Map<CharSequence, CharSequence> headers() {
        return this.headers == null ? Collections.emptyMap() : this.headers;
    }

    public synchronized Err withHeader(CharSequence name, CharSequence value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<CharSequence, CharSequence>();
        }
        this.headers.put((CharSequence)Checks.notNull((String)"name", (Object)name), (CharSequence)Checks.notNull((String)"value", (Object)value));
        return this;
    }

    public synchronized Err withHeaders(Map<? extends CharSequence, ? extends CharSequence> headers) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<CharSequence, CharSequence>();
        }
        headers.forEach((k, v) -> this.headers.put((CharSequence)k, (CharSequence)v));
        return this;
    }

    public synchronized Err putAll(Map<String, Object> m) {
        this.message.putAll(m);
        return this;
    }

    public static Err of(Throwable t) {
        while (t.getCause() != null && !(t instanceof ResponseException)) {
            t = t.getCause();
        }
        if (t instanceof ResponseException) {
            ResponseException ex = (ResponseException)t;
            return new Err(ex.status(), ex.getMessage()).withHeaders(ex.headers());
        }
        return new Err(t);
    }

    public static Err badRequest(String msg) {
        return new Err(HttpResponseStatus.BAD_REQUEST, msg);
    }

    public static Err gone(String msg) {
        return new Err(HttpResponseStatus.GONE, msg);
    }

    public static Err conflict(String msg) {
        return new Err(HttpResponseStatus.CONFLICT, msg);
    }

    public static Err forbidden(String msg) {
        return new Err(HttpResponseStatus.FORBIDDEN, msg);
    }

    static String unwind(Throwable t, boolean returnClassName) {
        String lastType;
        if (t == null) {
            return "Unknown";
        }
        Throwable orig = t;
        String lastMessage = null;
        do {
            if (t.getMessage() != null) {
                lastMessage = t.getMessage();
            }
            lastType = t.getClass().getName();
        } while ((t = t.getCause()) != null);
        if (lastMessage == null) {
            Throwable[] others;
            if (t == null) {
                t = orig;
            }
            if ((others = t.getSuppressed()) != null && others.length > 0) {
                Throwable other;
                String result;
                Throwable[] throwableArray = others;
                int n = throwableArray.length;
                for (int i = 0; i < n && (result = Err.unwind(other = throwableArray[i], false)) == null; ++i) {
                }
            }
        }
        if (lastMessage == null && returnClassName) {
            lastMessage = lastType;
        }
        return lastMessage;
    }

    public Err(String message) {
        this(HttpResponseStatus.INTERNAL_SERVER_ERROR, (Map<String, Object>)new ImmutableMap.Builder().put((Object)"error", (Object)message).build());
    }

    public Err(HttpResponseStatus code, String message) {
        this(code, (Map<String, Object>)new ImmutableMap.Builder().put((Object)"error", (Object)message).build());
    }

    public Err(HttpResponseStatus code, Map<String, Object> message) {
        this.status = code;
        this.message = message;
    }

    public Err put(String key, Object value) {
        ImmutableMap m = ImmutableMap.builder().putAll(this.message).put((Object)key, value).build();
        Err result = new Err(this.status, (Map<String, Object>)m);
        if (this.headers != null) {
            result.headers = this.headers;
        }
        return result;
    }

    public Err withCode(HttpResponseStatus code) {
        Err result = new Err(code, this.message);
        if (this.headers != null) {
            result.headers = this.headers;
        }
        return result;
    }

    public static Err withCode(int code) {
        return new Err(HttpResponseStatus.valueOf((int)code), "");
    }

    public static Err withCode(int code, String msg) {
        return new Err(HttpResponseStatus.valueOf((int)code), msg);
    }

    @Override
    public HttpResponseStatus status() {
        return this.status;
    }

    @Override
    public Object message() {
        return this.message;
    }
}

