/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.errors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.ImplementedBy;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.Response;
import com.mastfrog.acteur.errors.ErrorResponse;
import java.io.IOException;
import javax.inject.Inject;

@ImplementedBy(value=DefaultErrorRenderer.class)
public abstract class ErrorRenderer {
    public void render(ErrorResponse resp, Response into, Event<?> evt) throws IOException {
        String s = this.render(resp, evt);
        into.status(resp.status());
        if (s != null) {
            into.content(s);
        }
    }

    public abstract String render(ErrorResponse var1, Event<?> var2) throws IOException;

    static class DefaultErrorRenderer
    extends ErrorRenderer {
        private final ObjectMapper mapper;

        @Inject
        DefaultErrorRenderer(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public void render(ErrorResponse resp, Response into, Event<?> evt) throws JsonProcessingException {
            into.status(resp.status());
            into.content(resp.message());
        }

        @Override
        public String render(ErrorResponse resp, Event<?> evt) throws IOException {
            return this.mapper.writeValueAsString(resp.message());
        }
    }
}

