/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.errors;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collections;
import java.util.Map;

public interface ErrorResponse {
    public HttpResponseStatus status();

    public Object message();

    public static <T> ErrorResponse create(HttpResponseStatus status, T message) {
        return new Simple<T>(status, message);
    }

    default public Map<CharSequence, CharSequence> headers() {
        return Collections.emptyMap();
    }

    @Deprecated
    public static class Simple<T>
    implements ErrorResponse {
        public final HttpResponseStatus status;
        public final T message;

        public Simple(HttpResponseStatus status, T message) {
            this.status = status;
            this.message = message;
        }

        @Override
        public HttpResponseStatus status() {
            return this.status;
        }

        @Override
        public Object message() {
            return this.message;
        }

        public String toString() {
            return this.status + " " + this.message;
        }
    }
}

