/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.errors;

import com.google.common.collect.Lists;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.errors.Err;
import com.mastfrog.acteur.errors.ErrorResponse;
import com.mastfrog.acteur.errors.ExceptionEvaluator;
import com.mastfrog.settings.Settings;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class ExceptionEvaluatorRegistry {
    private final List<ExceptionEvaluator> evaluators = Lists.newCopyOnWriteArrayList();
    public static final String SETTINGS_KEY_DEFAULT_EXCEPTION_HANDLING = "default.exception.handling";

    @Inject
    ExceptionEvaluatorRegistry(Settings settings) {
        boolean prettyErrors = settings.getBoolean(SETTINGS_KEY_DEFAULT_EXCEPTION_HANDLING, true);
        if (prettyErrors) {
            new SimpleErrors(this);
        }
    }

    void register(ExceptionEvaluator eval) {
        this.evaluators.add(eval);
        Collections.sort(this.evaluators);
    }

    public ErrorResponse evaluate(Throwable t, Acteur acteur, Page page, Event<?> evt) {
        for (ExceptionEvaluator e : this.evaluators) {
            ErrorResponse response = e.evaluate(t, acteur, page, evt);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    private static final class SimpleErrors
    extends ExceptionEvaluator {
        SimpleErrors(ExceptionEvaluatorRegistry registry) {
            super(registry);
        }

        @Override
        protected int ordinal() {
            return Integer.MIN_VALUE;
        }

        @Override
        public ErrorResponse evaluate(Throwable t, Acteur acteur, Page page, Event<?> evt) {
            return new Err(t, true);
        }
    }
}

