/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.preconditions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Page;
import com.mastfrog.giulius.Ordered;
import com.mastfrog.util.preconditions.ConfigurationError;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public abstract class PageAnnotationHandler {
    private final Set<Class<? extends Annotation>> types;

    protected PageAnnotationHandler(Registry registry, Class<?> ... annotationTypes) {
        HashSet tps = new HashSet();
        for (Class<?> type : annotationTypes) {
            if (!Annotation.class.isAssignableFrom(type)) {
                throw new ConfigurationError("Not an annotation type: " + type.getName());
            }
            Retention retention = type.getAnnotation(Retention.class);
            if (retention == null) {
                throw new ConfigurationError("Not annotated with @Retention: " + type.getName());
            }
            if (retention.value() != RetentionPolicy.RUNTIME) {
                throw new ConfigurationError("Attempting to use " + type.getName() + " as a page annotation, but it does not have @Retention(RUNTIME)");
            }
            tps.add(type);
        }
        this.types = ImmutableSet.copyOf(tps);
        registry.register(this);
    }

    public abstract <T extends Page> boolean processAnnotations(T var1, List<? super Acteur> var2);

    protected final Set<Class<? extends Annotation>> types() {
        return this.types;
    }

    @Singleton
    public static final class Registry {
        private final List<PageAnnotationHandler> handlers = new LinkedList<PageAnnotationHandler>();
        private final Set<Class<? super Page>> annotatedPages = Sets.newConcurrentHashSet();
        private volatile Set<Class<? extends Annotation>> types;

        @Inject
        public Registry() {
        }

        public <T extends Page> boolean processAnnotations(T page, List<? super Acteur> addTo) {
            boolean result = false;
            for (PageAnnotationHandler handler : this.handlers) {
                result |= handler.processAnnotations(page, addTo);
            }
            return result;
        }

        public <T extends Page> boolean hasAnnotations(T page) {
            Class<?> c = page.getClass();
            if (this.annotatedPages.contains(page.getClass())) {
                return true;
            }
            for (Class<? extends Annotation> type : this.types()) {
                if (c.getAnnotation(type) == null) continue;
                this.annotatedPages.add(c);
                return true;
            }
            return false;
        }

        public void register(PageAnnotationHandler handler) {
            this.handlers.add(handler);
            Collections.sort(this.handlers, new Ordered.OrderedObjectComparator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Class<? extends Annotation>> types() {
            if (this.types == null) {
                Registry registry = this;
                synchronized (registry) {
                    if (this.types == null) {
                        ImmutableSet.Builder builder = ImmutableSet.builder();
                        for (PageAnnotationHandler h : this.handlers) {
                            builder.addAll(h.types());
                        }
                        this.types = builder.build();
                    }
                }
            }
            return this.types;
        }
    }
}

