/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.server.PathFactory;
import com.mastfrog.settings.Settings;
import com.mastfrog.url.Path;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.Protocols;
import com.mastfrog.url.URL;
import com.mastfrog.url.URLBuilder;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.ConfigurationError;
import com.mastfrog.util.preconditions.Exceptions;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
class DefaultPathFactory
implements PathFactory {
    private static final AsciiString X_URL_SCHEME = new AsciiString((CharSequence)"X-Url-Scheme");
    private static final AsciiString X_FORWARDED_SSL = new AsciiString((CharSequence)"X-Forwarded-Ssl");
    private static final AsciiString FRONT_END_HTTPS = new AsciiString((CharSequence)"Front-End-Https");
    private static final AsciiString FORWARDED = new AsciiString((CharSequence)"Forwarded");
    private static final Pattern FORWARDED_SUB_PATTERN = Pattern.compile("proto=(\\S+)[;$]");
    private static final Pattern STRIP_QUERY = Pattern.compile("(.*?)\\?(.*)");
    private static final int URI_TO_PATH_CACHE_PRUNE_INTERVAL = 64;
    private static final int URI_TO_PATH_CACHE_EXPIRY_MILLIS = 300000;
    private final Map<String, PathCacheEntry> cache = new ConcurrentHashMap<String, PathCacheEntry>(256, 0.9f);
    private int hits = Integer.MIN_VALUE;
    private final int port;
    private final int securePort;
    private final String hostname;
    private final Path pth;
    private final boolean secure;

    @Inject
    DefaultPathFactory(Settings settings) {
        int port = settings.getInt("external.port", -1);
        if (port == -1) {
            port = settings.getInt("port", Protocols.HTTP.getDefaultPort().intValue());
        }
        this.port = port;
        int secPort = settings.getInt("external.secure.port", settings.getInt("securePort", Protocols.HTTPS.getDefaultPort().intValue()));
        if (secPort < 0) {
            throw new ConfigurationError("external.secure.port cannot be negative: " + secPort);
        }
        if (port < 0) {
            throw new ConfigurationError("external.port cannot be negative: " + secPort);
        }
        this.securePort = secPort;
        this.secure = settings.getBoolean("secure.urls", settings.getBoolean("ssl.enabled", settings.getBoolean("use.secure.urls", false)));
        String hn = settings.getString("hostname");
        if (hn == null) {
            if (settings.getBoolean("urls.use.inetaddress.localhost", false)) {
                try {
                    hn = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    hn = "localhost";
                }
            } else {
                hn = "localhost";
            }
        }
        this.hostname = hn;
        String path = settings.getString("basepath", "");
        this.pth = Path.parse((String)path);
        if (!this.pth.isValid()) {
            throw new ConfigurationError("basepath is not a valid URL path: '" + path + "'");
        }
    }

    @Override
    public int portForProtocol(Protocol protocol) {
        if (protocol.isSecure()) {
            return this.securePort;
        }
        return this.port;
    }

    private Path basePath() {
        return this.pth;
    }

    @Override
    public Path toExternalPath(String path) {
        return this.toExternalPath(Path.parse((String)path));
    }

    @Override
    public Path toExternalPath(Path path) {
        return Path.merge((Path[])new Path[]{this.basePath(), path});
    }

    @Override
    public URL constructURL(Path path) {
        return this.constructURL(path, this.secure);
    }

    private PathCacheEntry load(String uri) {
        Matcher m;
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if ((m = STRIP_QUERY.matcher(uri)).matches()) {
            uri = m.group(1);
        }
        if (uri.startsWith(this.basePath().toString())) {
            uri = uri.substring(this.basePath().toString().length());
        }
        if (uri.length() > 1 && uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        Path result = Path.parse((String)uri, (boolean)true);
        return new PathCacheEntry(result);
    }

    private void pruneCache() {
        Iterator<Map.Entry<String, PathCacheEntry>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PathCacheEntry> e = it.next();
            if (!e.getValue().isExpired()) continue;
            it.remove();
        }
    }

    @Override
    public Path toPath(String uri) {
        if (this.hits++ % 64 == 0) {
            this.pruneCache();
        }
        PathCacheEntry pce = this.cache.computeIfAbsent(uri, this::load);
        return pce.path();
    }

    @Override
    public URL constructURL(Protocol protocol, Path path) {
        return this.constructURL(protocol, path, this.secure);
    }

    @Override
    public URL constructURL(Protocol protocol, Path path, boolean secure) {
        return this.constructURL(protocol, path, secure ? this.securePort : this.port);
    }

    @Override
    public URL constructURL(Protocol protocol, Path path, int port) {
        Checks.nonNegative((String)"port", (int)port);
        if (this.basePath().size() > 0) {
            path = Path.merge((Path[])new Path[]{this.basePath(), path});
        }
        URLBuilder b = URL.builder((Protocol)protocol).setPath(path).setHost(this.hostname);
        if (port > 0) {
            b.setPort(port);
        }
        return b.create();
    }

    @Override
    public URL constructURL(Path path, boolean secure) {
        if (this.basePath().size() > 0) {
            path = Path.merge((Path[])new Path[]{this.basePath(), (Path)Checks.notNull((String)"path", (Object)path)});
        }
        Protocols protocol = secure ? Protocols.HTTPS : Protocols.HTTP;
        URLBuilder b = URL.builder((Protocol)(secure ? Protocols.HTTPS : Protocols.HTTP)).setPath(path).setHost(this.hostname);
        if (this.port > 0 && this.port != protocol.getDefaultPort().intValue()) {
            b.setPort(secure ? this.securePort : this.port);
        }
        return b.create();
    }

    static CharSequence findProtocol(HttpEvent evt) {
        Matcher m;
        String s;
        CharSequence proto;
        CharSequence charSequence = proto = evt == null ? null : (CharSequence)evt.header(Headers.X_FORWARDED_PROTO);
        if (proto == null && evt != null) {
            proto = evt.header((CharSequence)X_URL_SCHEME);
        }
        if (proto == null && evt != null) {
            if ("on".equals(evt.header((CharSequence)X_FORWARDED_SSL))) {
                proto = "https";
            } else if ("on".equals(evt.header((CharSequence)FRONT_END_HTTPS))) {
                proto = "https";
            }
        }
        if (proto == null && evt != null && (s = evt.header((CharSequence)FORWARDED)) != null && (m = FORWARDED_SUB_PATTERN.matcher(s)).find()) {
            proto = m.group(1);
        }
        return proto;
    }

    @Override
    public URL constructURL(String path, HttpEvent evt) {
        Path pth;
        int qix = path.indexOf(63);
        String query = null;
        String anchor = null;
        if (qix > 0 && qix < path.length() - 1) {
            query = path.substring(qix + 1);
            path = path.substring(0, qix);
            int aix = query.indexOf(35);
            if (aix >= 0 && aix < query.length() - 2) {
                anchor = query.substring(aix + 1);
                query = query.substring(0, aix);
            }
        }
        if (!(pth = Path.parse((String)path)).isValid()) {
            throw new IllegalArgumentException("Invalid path '" + path + "'");
        }
        String host = evt == null ? null : evt.header((CharSequence)HttpHeaderNames.HOST);
        CharSequence proto = DefaultPathFactory.findProtocol(evt);
        URL base = this.constructURL(path);
        if (host == null) {
            if (query != null || anchor != null) {
                URLBuilder bldr = new URLBuilder(base);
                DefaultPathFactory.applyQueryString(query, bldr);
                if (anchor != null) {
                    bldr.setAnchor(anchor);
                }
                return bldr.create();
            }
            if (proto != null) {
                URLBuilder bldr = new URLBuilder(base);
                Protocol protocol = Protocols.forName((String)proto.toString());
                bldr.setProtocol(protocol);
                bldr.setPort(this.portForProtocol(protocol));
                return bldr.create();
            }
            return base;
        }
        String[] hostPort = host.split(":");
        URLBuilder bldr = new URLBuilder(this.constructURL(pth));
        bldr.setHost(hostPort[0]);
        if (hostPort.length > 1 && hostPort[1].length() > 0) {
            try {
                int portFromHostHeader = Integer.parseInt(hostPort[1]);
                bldr.setPort(portFromHostHeader);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Port in host header is not a number: '" + hostPort[1] + "'");
            }
        }
        DefaultPathFactory.applyQueryString(query, bldr);
        if (anchor != null) {
            bldr.setAnchor(anchor);
        }
        if (proto != null) {
            Protocol protocol = Protocols.forName((String)proto.toString());
            bldr.setProtocol(protocol);
            bldr.setPort(this.portForProtocol(protocol));
        }
        return bldr.create();
    }

    static boolean applyQueryString(String query, URLBuilder bldr) {
        if (query == null || query.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (String item : query.split("&")) {
            int ix = item.indexOf(61);
            if (ix < 0) continue;
            String[] kv = item.split("=", 2);
            if (kv.length > 1) {
                bldr.addQueryPair(kv[0], kv[1]);
            } else {
                bldr.addQueryPair(kv[0], "");
            }
            result = true;
        }
        return result;
    }

    private static final class PathCacheEntry {
        private long touched = System.currentTimeMillis();
        private final Path path;

        public PathCacheEntry(Path path) {
            this.path = path;
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.touched > 300000L;
        }

        Path path() {
            this.touched = System.currentTimeMillis();
            return this.path;
        }
    }
}

