/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.Singleton;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.server.PipelineDecorator;
import com.mastfrog.acteur.server.UpstreamHandlerImpl;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpRequest;
import javax.inject.Inject;

@Singleton
@ChannelHandler.Sharable
class EarlyPagesPipelineDecorator
implements PipelineDecorator {
    private final Handler handler;

    @Inject
    EarlyPagesPipelineDecorator(Application app, ChannelHandler upstream) {
        this.handler = app.hasEarlyPages() ? new Handler(app, (UpstreamHandlerImpl)upstream) : null;
    }

    @Override
    public void onCreatePipeline(ChannelPipeline pipeline) {
        if (this.handler != null) {
            pipeline.addAfter("decoder", "early", (ChannelHandler)this.handler);
            pipeline.remove("deflater");
        }
    }

    @Override
    public void onPipelineInitialized(ChannelPipeline pipeline) {
    }

    @Singleton
    @ChannelHandler.Sharable
    static final class Handler
    extends SimpleChannelInboundHandler<HttpRequest> {
        private final Application application;
        private final UpstreamHandlerImpl upstream;

        private Handler(Application app, UpstreamHandlerImpl upstreamHandlerImpl) {
            this.application = app;
            this.upstream = upstreamHandlerImpl;
        }

        public boolean acceptInboundMessage(Object msg) throws Exception {
            if (msg instanceof HttpRequest) {
                HttpRequest r = (HttpRequest)msg;
                return this.application.isEarlyPageMatch(r);
            }
            return false;
        }

        protected void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) throws Exception {
            this.upstream.handleHttpRequest(ctx, msg, true);
        }
    }
}

