/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import com.mastfrog.acteur.ContentConverter;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.server.DefaultPathFactory;
import com.mastfrog.acteur.server.PathFactory;
import com.mastfrog.acteur.server.ServerModule;
import com.mastfrog.mime.MimeType;
import com.mastfrog.url.Path;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.Protocols;
import com.mastfrog.url.URL;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EventImpl
implements HttpEvent {
    private static final Pattern PORT_PATTERN = Pattern.compile(".*?:(\\d+)");
    private static final AsciiString HTTPS = AsciiString.of((CharSequence)"https");
    private final HttpRequest req;
    private final Path path;
    private final SocketAddress address;
    private final PathFactory paths;
    private boolean neverKeepAlive = false;
    private final ChannelHandlerContext channel;
    private ContentConverter converter;
    private boolean ssl;
    private boolean early;
    private Map<String, String> paramsMap;

    EventImpl(HttpRequest req, PathFactory paths) {
        this.req = req;
        this.path = paths.toPath(req.uri());
        this.paths = paths;
        this.address = new InetSocketAddress("timboudreau.com", 8985);
        this.channel = null;
        ServerModule.CodecImpl codec = new ServerModule.CodecImpl((Provider<ObjectMapper>)Providers.of((Object)new ObjectMapper()));
        this.converter = new ContentConverter(codec, (Provider<Charset>)Providers.of((Object)CharsetUtil.UTF_8), null);
    }

    EventImpl(HttpRequest req, SocketAddress addr, ChannelHandlerContext channel, PathFactory paths, ContentConverter converter, boolean ssl) {
        this.req = req;
        this.path = paths.toPath(req.uri());
        this.address = addr;
        this.channel = channel;
        this.converter = converter;
        this.ssl = ssl;
        this.paths = paths;
    }

    @Override
    public boolean isPreContent() {
        return this.early;
    }

    @Override
    public String getRequestURL(boolean preferHeaders) {
        String configuredHost;
        String host;
        EventImpl evt = this;
        String uri = ((HttpRequest)evt.request()).uri();
        if (uri.startsWith("http://") || uri.startsWith("https://")) {
            return uri;
        }
        URL takeFrom = this.paths.constructURL("/");
        CharSequence proto = DefaultPathFactory.findProtocol(evt);
        if (proto == null) {
            proto = takeFrom.getProtocol().toString();
        }
        if ((host = evt.header("X-Forwarded-Host")) == null) {
            host = evt.header((CharSequence)HttpHeaderNames.HOST);
        }
        int port = -1;
        if (host != null && host.indexOf(58) > 0) {
            port = EventImpl.findPort(host);
            host = host.substring(0, host.indexOf(58));
            if (port != -1 && Protocols.forName((String)proto.toString()).getDefaultPort().intValue() == port) {
                port = -1;
            } else if (port != -1 && Protocols.forName((String)proto.toString()).getDefaultPort().intValue() != port) {
                host = host + ":" + port;
            }
        }
        if (!preferHeaders && !(configuredHost = takeFrom.getHost().toString()).equals("localhost")) {
            host = configuredHost;
            port = takeFrom.getPort().intValue();
            proto = takeFrom.getProtocol().toString();
            Protocol protocol = Protocols.forName((String)proto.toString());
            if (port != -1 && port != protocol.getDefaultPort().intValue()) {
                host = host + ":" + takeFrom.getPort().intValue();
            }
        }
        if (uri.length() == 0 || uri.charAt(0) != '/') {
            host = host + '/';
        }
        return proto + "://" + host + uri;
    }

    private static int findPort(String what) {
        Matcher m = PORT_PATTERN.matcher(what);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return -1;
    }

    EventImpl early() {
        this.early = true;
        return this;
    }

    @Override
    public boolean isSsl() {
        CharSequence cs;
        boolean result = this.ssl;
        if (!result && (cs = (CharSequence)this.header(Headers.X_FORWARDED_PROTO)) != null) {
            result = HTTPS.contentEqualsIgnoreCase((CharSequence)HTTPS);
        }
        return result;
    }

    public String toString() {
        return this.req.method() + "\t" + this.req.uri();
    }

    public void setNeverKeepAlive(boolean val) {
        this.neverKeepAlive = val;
    }

    @Override
    public Channel channel() {
        return this.channel.channel();
    }

    @Override
    public ChannelHandlerContext ctx() {
        return this.channel;
    }

    @Override
    public ByteBuf content() {
        return this.req instanceof ByteBufHolder ? ((ByteBufHolder)this.req).content() : Unpooled.EMPTY_BUFFER;
    }

    @Override
    public <T> T jsonContent(Class<T> type) throws Exception {
        MimeType mimeType = (MimeType)this.header(Headers.CONTENT_TYPE);
        if (mimeType == null) {
            mimeType = MimeType.ANY_TYPE;
        }
        return this.converter.toObject(this.content(), mimeType, type);
    }

    @Override
    public String stringContent() throws IOException {
        ByteBuf content = this.content();
        if (content == null) {
            return "";
        }
        MimeType type = (MimeType)this.header(Headers.CONTENT_TYPE);
        if (type == null) {
            type = MimeType.PLAIN_TEXT_UTF_8;
        }
        return this.converter.toString(content, type.charset().orElse(CharsetUtil.UTF_8));
    }

    @Override
    public HttpRequest request() {
        return this.req;
    }

    public Method method() {
        try {
            return Method.get((HttpRequest)this.req);
        }
        catch (IllegalArgumentException e) {
            return Method.UNKNOWN;
        }
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.address;
    }

    @Override
    public String header(CharSequence nm) {
        return this.req.headers().get((CharSequence)Checks.notNull((String)"nm", (Object)nm));
    }

    @Override
    public String urlParameter(String param) {
        return this.urlParametersAsMap().get(param);
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public <T> List<T> headers(HeaderValueType<T> headerType) {
        List headers = CollectionUtils.generalize((List)this.request().headers().getAll(headerType.name()));
        return CollectionUtils.convertedList((List)headers, headerType, CharSequence.class, (Class)headerType.type());
    }

    @Override
    public Map<CharSequence, CharSequence> headersAsMap() {
        Map headers = CollectionUtils.caseInsensitiveStringMap();
        for (Map.Entry e : this.request().headers().entries()) {
            headers.put((CharSequence)e.getKey(), (CharSequence)e.getValue());
        }
        return headers;
    }

    @Override
    public <T> T header(HeaderValueType<T> value) {
        String header = this.header(value.name());
        if (header != null) {
            return (T)value.toValue((CharSequence)header);
        }
        return null;
    }

    @Override
    public synchronized Map<String, String> urlParametersAsMap() {
        if (this.paramsMap == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.req.uri());
            Map params = queryStringDecoder.parameters();
            TreeMap<String, String> result = new TreeMap<String, String>();
            for (Map.Entry e : params.entrySet()) {
                if (((List)e.getValue()).isEmpty()) continue;
                result.put((String)e.getKey(), (String)((List)e.getValue()).get(0));
            }
            this.paramsMap = Collections.unmodifiableMap(result);
        }
        return this.paramsMap;
    }

    @Override
    public <T> T urlParametersAs(Class<T> type) {
        return this.converter.toObject(this.urlParametersAsMap(), type);
    }

    @Override
    public boolean requestsConnectionStayOpen() {
        if (this.neverKeepAlive) {
            return false;
        }
        boolean hasKeepAlive = this.req.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true);
        return hasKeepAlive;
    }

    @Override
    public Optional<Integer> intUrlParameter(String name) {
        String val = this.urlParameter(name);
        if (val != null) {
            int ival = Integer.parseInt(val);
            return Optional.of(ival);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> longUrlParameter(String name) {
        String val = this.urlParameter(name);
        if (val != null) {
            long lval = Long.parseLong(val);
            return Optional.of(lval);
        }
        return Optional.empty();
    }

    public <T> Optional<T> httpHeader(HeaderValueType<T> header) {
        return Optional.ofNullable(this.header((HeaderValueType)Checks.notNull((String)"header", header)));
    }

    public Optional<CharSequence> httpHeader(CharSequence name) {
        return Optional.ofNullable(this.header(name));
    }

    public Optional<CharSequence> uriAnchor() {
        String u = this.req.uri();
        int ix = u.indexOf(35);
        if (ix >= 0) {
            return Optional.of(u.substring(ix + 1));
        }
        return Optional.empty();
    }

    public Optional<CharSequence> uriPathElement(int index) {
        Path p = this.path();
        if (p.size() >= Checks.nonNegative((String)"index", (int)index)) {
            return Optional.empty();
        }
        return Optional.of(p.getElement(index).toString());
    }

    public Optional<CharSequence> uriQueryParameter(CharSequence name, boolean decode) {
        String val = this.urlParametersAsMap().get(((CharSequence)Checks.notNull((String)"name", (Object)name)).toString());
        return Optional.ofNullable(val);
    }

    public String httpMethod() {
        return this.method().toString();
    }

    public String requestUri(boolean preferHeaders) {
        return this.getRequestURL(preferHeaders);
    }

    public Set<? extends CharSequence> httpHeaderNames() {
        TreeSet<CharSequence> result = new TreeSet<CharSequence>(Strings.charSequenceComparator((boolean)true));
        Iterator it = this.req.headers().iteratorCharSequence();
        while (it.hasNext()) {
            result.add((CharSequence)((Map.Entry)it.next()).getKey());
        }
        return result;
    }
}

