/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.ImplementedBy;
import com.google.inject.name.Named;
import com.mastfrog.acteur.server.NioServerChannelFactory;
import com.mastfrog.giulius.thread.ThreadCount;
import com.mastfrog.settings.Settings;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Singleton;

@ImplementedBy(value=DefaultEventLoopFactory.class)
public abstract class EventLoopFactory {
    public abstract EventLoopGroup getEventGroup();

    public abstract EventLoopGroup getWorkerGroup();

    protected Class<? extends ServerChannel> channelType() {
        return NioServerSocketChannel.class;
    }

    protected ChannelFactory<? extends ServerChannel> channelFactory() {
        if (this.channelType() == NioServerSocketChannel.class) {
            return new NioServerChannelFactory(false);
        }
        return null;
    }

    protected ServerBootstrap configureBootstrap(ServerBootstrap bootstrap) {
        bootstrap.group(this.getEventGroup(), this.getWorkerGroup());
        ChannelFactory<? extends ServerChannel> channelFactory = this.channelFactory();
        if (channelFactory == null) {
            try {
                bootstrap.channel(this.channelType());
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            try {
                bootstrap.channelFactory(channelFactory);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return bootstrap;
    }

    @Singleton
    static final class DefaultEventLoopFactory
    extends EventLoopFactory {
        private final EventLoopGroup events;
        private final EventLoopGroup workers;
        private final boolean debug;

        @Inject
        DefaultEventLoopFactory(@Named(value="eventThreads") Executor eventThreadFactory, @Named(value="eventThreads") ThreadCount eventThreadCount, @Named(value="workers") Executor workerThreadFactory, @Named(value="workers") ThreadCount workerThreadCount, Settings settings) {
            this.debug = settings.getBoolean("channel.debug", false);
            this.events = new NioEventLoopGroup(eventThreadCount.get(), eventThreadFactory);
            this.workers = new NioEventLoopGroup(workerThreadCount.get(), workerThreadFactory);
        }

        @Override
        protected ChannelFactory<? extends ServerChannel> channelFactory() {
            return new NioServerChannelFactory(this.debug);
        }

        @Override
        public EventLoopGroup getEventGroup() {
            return this.events;
        }

        @Override
        public EventLoopGroup getWorkerGroup() {
            return this.workers;
        }
    }
}

