/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.Provider;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.server.ActeurSslConfig;
import com.mastfrog.acteur.server.EarlyPagesPipelineDecorator;
import com.mastfrog.acteur.server.PipelineDecorator;
import com.mastfrog.acteur.server.ServerModule;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.function.threadlocal.ThreadLocalValue;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.preconditions.ConfigurationError;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class PipelineFactoryImpl
extends ChannelInitializer<SocketChannel> {
    private static final String SETTINGS_KEY_AGGREGATE_CHUNKS = "aggregateChunks";
    private static final String SETTINGS_KEY_HTTP_COMPRESSION_DEBUG = "http.compression.debug";
    static final boolean DEFAULT_AGGREGATE_CHUNKS = true;
    static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    private final Provider<ChannelHandler> handler;
    private final boolean aggregateChunks;
    private final int maxContentLength;
    private final boolean httpCompression;
    private final Provider<ApplicationControl> app;
    private final PipelineDecorator decorator;
    private final ActeurSslConfig sslConfigProvider;
    boolean useSsl;
    private final EarlyPagesPipelineDecorator earlyPages;
    private final Application application;
    private final int maxInitialLineLength;
    private final int maxHeadersSize;
    private final int maxChunkSize;
    private final int compressionLevel;
    private final int compressionWindowBits;
    private final int compressionMemLevel;
    private final int compressionThreshold;
    private final boolean compressionCheckContentType;
    private final boolean compressionDebug;
    static final boolean ACTEUR_DEBUG = Boolean.getBoolean("acteur.debug");
    private static final AsciiString COMPRESS_DEBUG_HEADER = AsciiString.of((CharSequence)"X-Compressed");
    private static final AsciiString TRUE = AsciiString.of((CharSequence)"1");
    static final AttributeKey<Boolean> EARLY_KEY = AttributeKey.newInstance((String)SelectiveAggregator.class.getSimpleName());

    @Inject
    PipelineFactoryImpl(Provider<ChannelHandler> handler, Provider<ApplicationControl> app, Settings settings, PipelineDecorator decorator, ActeurSslConfig sslConfigProvider, EarlyPagesPipelineDecorator earlyPages, Application application) {
        this.decorator = decorator;
        this.handler = handler;
        this.app = app;
        this.sslConfigProvider = sslConfigProvider;
        this.aggregateChunks = settings.getBoolean(SETTINGS_KEY_AGGREGATE_CHUNKS, true);
        this.compressionDebug = settings.getBoolean(SETTINGS_KEY_HTTP_COMPRESSION_DEBUG, false);
        this.httpCompression = settings.getBoolean("httpCompression", true);
        this.maxContentLength = settings.getInt("maxContentLength", 0x100000);
        this.useSsl = settings.getBoolean("ssl.enabled", false);
        this.maxInitialLineLength = settings.getInt("max.request.line.length", 4096);
        this.maxHeadersSize = settings.getInt("max.header.buffer.size", 8192);
        this.maxChunkSize = settings.getInt("max.chunk.size", 8192);
        this.earlyPages = earlyPages;
        this.application = application;
        this.compressionLevel = PipelineFactoryImpl.fetchIntFromSettingsWithRangeCheck("compression.level", settings, 0, 9, 6);
        this.compressionWindowBits = PipelineFactoryImpl.fetchIntFromSettingsWithRangeCheck("compression.window.bits", settings, 9, 16, 15);
        this.compressionMemLevel = PipelineFactoryImpl.fetchIntFromSettingsWithRangeCheck("compression.memory.level", settings, 1, 9, 8);
        this.compressionCheckContentType = settings.getBoolean("compression.check.content.type", false);
        this.compressionThreshold = settings.getInt("compression.threshold", 256);
        if (this.compressionThreshold < 0) {
            throw new ConfigurationError("compression.threshold may not be < 0 but is " + this.compressionThreshold);
        }
    }

    private static int fetchIntFromSettingsWithRangeCheck(String name, Settings settings, int min, int max, int def) {
        int val = settings.getInt(name, def);
        if (val < min) {
            throw new ConfigurationError(name + " must be between " + min + " and " + max + " but is set to " + val + " in settings.  Check your configuration.");
        }
        return val;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ((ApplicationControl)this.app.get()).internalOnError(cause);
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        ch.attr(ServerModule.SSL_ATTRIBUTE_KEY).set((Object)this.useSsl);
        if (this.useSsl) {
            this.decorator.onBeforeInstallSslHandler(pipeline);
            pipeline.addLast("ssl", (ChannelHandler)this.sslConfigProvider.get().newHandler(ch.alloc()));
        }
        this.decorator.onCreatePipeline(pipeline);
        HttpRequestDecoder decoder = new HttpRequestDecoder(this.maxInitialLineLength, this.maxHeadersSize, this.maxChunkSize);
        boolean hasEarly = this.application.hasEarlyPages();
        HackHttpResponseEncoder encoder = new HackHttpResponseEncoder();
        pipeline.addLast("decoder", (ChannelHandler)decoder);
        pipeline.addLast("encoder", (ChannelHandler)encoder);
        if (this.aggregateChunks) {
            HttpObjectAggregator aggregator = hasEarly ? new SelectiveAggregator(this.maxContentLength, this.application) : new Agg(this.maxContentLength);
            pipeline.addLast("aggregator", (ChannelHandler)aggregator);
        }
        if (this.httpCompression) {
            SelectiveCompressor compressor = new SelectiveCompressor(this.compressionLevel, this.compressionWindowBits, this.compressionMemLevel, this.compressionThreshold, this.compressionCheckContentType, this.compressionDebug);
            pipeline.addLast("deflater", (ChannelHandler)compressor);
        }
        pipeline.addLast("handler", (ChannelHandler)this.handler.get());
        this.earlyPages.onCreatePipeline(pipeline);
        this.decorator.onPipelineInitialized(pipeline);
    }

    static final class HackHttpResponseEncoder
    extends HttpResponseEncoder {
        HackHttpResponseEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            if (msg instanceof ByteBuf && ((ByteBuf)msg).readableBytes() > 0) {
                out.add(((ByteBuf)msg).retain());
                ((ByteBuf)msg).touch((Object)"hack-http-response-encode");
                return;
            }
            if (msg instanceof ByteBuf && ((ByteBuf)msg).readableBytes() == 0) {
                ((ByteBuf)msg).touch((Object)"hack-http-response-encode-2");
                return;
            }
            super.encode(ctx, msg, out);
        }
    }

    static final class SelectiveAggregator
    extends HttpObjectAggregator {
        static final ThreadLocalValue<ChannelHandlerContext> localCtx = ThreadLocalValue.create();
        private final Application app;
        private final boolean hasEarlyPages;

        public SelectiveAggregator(int maxContentLength, Application app) {
            super(maxContentLength);
            this.app = app;
            this.hasEarlyPages = app.hasEarlyPages();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!this.hasEarlyPages) {
                super.channelRead(ctx, msg);
                return;
            }
            try (QuietAutoClosable cl = localCtx.setTo((Object)ctx);){
                super.channelRead(ctx, msg);
            }
        }

        public boolean acceptInboundMessage(Object msg) throws Exception {
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).touch((Object)"selective-agg-accept-inbound");
            }
            if (!this.hasEarlyPages) {
                return super.acceptInboundMessage(msg);
            }
            if (super.acceptInboundMessage(msg)) {
                ChannelHandlerContext ctx = (ChannelHandlerContext)localCtx.get();
                assert (ctx != null) : "No context";
                Boolean e = (Boolean)ctx.channel().attr(EARLY_KEY).get();
                if (e != null && e.booleanValue()) {
                    return false;
                }
                if (msg instanceof HttpRequest) {
                    HttpRequest req = (HttpRequest)msg;
                    if (this.app.isEarlyPageMatch(req)) {
                        ctx.channel().attr(EARLY_KEY).set((Object)true);
                        return false;
                    }
                    ctx.channel().attr(EARLY_KEY).set((Object)false);
                } else {
                    Boolean early = (Boolean)ctx.channel().attr(EARLY_KEY).get();
                    if (early != null && early.booleanValue()) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    static final class Agg
    extends HttpObjectAggregator {
        public Agg(int maxContentLength) {
            super(maxContentLength);
        }

        public Agg(int maxContentLength, boolean closeOnExpectationFailed) {
            super(maxContentLength, closeOnExpectationFailed);
        }

        protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
            aggregated.touch((Object)"agg-finish-aggregation");
            super.finishAggregation(aggregated);
        }

        protected void aggregate(FullHttpMessage aggregated, HttpContent content) throws Exception {
            aggregated.touch((Object)"agg-aggregate");
            content.touch((Object)"agg-aggregate-content");
            super.aggregate(aggregated, content);
        }

        protected Object newContinueResponse(HttpMessage start, int maxContentLength, ChannelPipeline pipeline) {
            Object result = super.newContinueResponse(start, maxContentLength, pipeline);
            if (result instanceof ReferenceCounted) {
                ((ReferenceCounted)result).touch((Object)"agg-new-continue-resp");
            }
            return result;
        }
    }

    static final class SelectiveCompressor
    extends HttpContentCompressor {
        private final int compressionThreshold;
        private final boolean compressionCheckContentType;
        private final boolean debug;

        SelectiveCompressor(int compressionLevel, int windowBits, int memLevel, int compressionThreshold, boolean compressionCheckContentType, boolean compressionDebug) {
            super(compressionLevel, windowBits, memLevel);
            this.compressionThreshold = compressionThreshold;
            this.compressionCheckContentType = compressionCheckContentType;
            this.debug = compressionDebug;
        }

        protected ZlibWrapper determineWrapper(String acceptEncoding) {
            ZlibWrapper result = super.determineWrapper(acceptEncoding);
            if (this.debug) {
                if (result != null) {
                    System.out.println("Using ZlibWrapper " + result.name() + " for " + acceptEncoding);
                } else {
                    System.out.println("Did not find ZlibWrapper for " + acceptEncoding + " - will not compress");
                }
            }
            return result;
        }

        protected void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
            if (this.debug) {
                System.out.println("Encode " + msg);
            }
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).touch((Object)"selective-compressor-encode");
            }
            super.encode(ctx, msg, out);
        }

        public boolean acceptInboundMessage(Object msg) throws Exception {
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).touch((Object)"sel-compressor-accept-inbound");
            }
            boolean result = super.acceptInboundMessage(msg);
            return result;
        }

        protected HttpContentEncoder.Result beginEncode(HttpResponse headers, String acceptEncoding) throws Exception {
            HttpContentEncoder.Result result;
            String contentType;
            HttpHeaders hdrs = headers.headers();
            Integer contentLength = hdrs.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (this.debug) {
                System.out.println("beginEncode " + acceptEncoding + " of " + headers);
            }
            if (contentLength != null && contentLength < this.compressionThreshold) {
                if (this.debug) {
                    System.out.println("Content length below threshold, not compressing.");
                }
                return null;
            }
            if (hdrs.contains((CharSequence)ServerModule.X_INTERNAL_COMPRESS)) {
                if (this.debug) {
                    System.out.println("Found X-Internal-Compress header, not compressing.");
                }
                hdrs.remove((CharSequence)ServerModule.X_INTERNAL_COMPRESS);
                return null;
            }
            if (this.compressionCheckContentType && (contentType = hdrs.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null && (contentType.startsWith("image/") || contentType.startsWith("video/") || contentType.startsWith("audio/"))) {
                if (this.debug) {
                    System.out.println("Media content, not compressing.");
                }
                return null;
            }
            if (headers instanceof ReferenceCounted) {
                ((ReferenceCounted)headers).touch((Object)"selective-compressor-encode");
            }
            if ((result = super.beginEncode(headers, acceptEncoding)) != null) {
                if (ACTEUR_DEBUG) {
                    hdrs.add((CharSequence)COMPRESS_DEBUG_HEADER, (Object)TRUE);
                }
            } else if (this.debug) {
                System.out.println("Compressor returned null, not compressing.");
            }
            return result;
        }
    }
}

