/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.errors.Err;
import com.mastfrog.acteur.errors.ErrorResponse;
import com.mastfrog.acteur.errors.ExceptionEvaluator;
import com.mastfrog.acteur.errors.ExceptionEvaluatorRegistry;
import com.mastfrog.acteur.server.ActeurSslConfig;
import com.mastfrog.acteur.util.ErrorHandler;
import com.mastfrog.giulius.Ordered;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.net.ssl.SSLException;

final class SelfSignedSslConfig
extends ActeurSslConfig {
    private final Provider<SslProvider> provider;
    private final Provider<ErrorHandler.Registry> reg;

    @Inject
    SelfSignedSslConfig(Provider<SslProvider> provider, Provider<ErrorHandler.Registry> reg) {
        this.provider = provider;
        this.reg = reg;
    }

    @Override
    public SslContext createSslContext() throws CertificateException, SSLException {
        new SuppressUnknownCertificateAlertsHandler((ErrorHandler.Registry)this.reg.get());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        return SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider((SslProvider)this.provider.get()).build();
    }

    private static class SuppressUnknownCertificateAlertsHandler
    extends ErrorHandler {
        private SuppressUnknownCertificateAlertsHandler(ErrorHandler.Registry handlers) {
            super(handlers);
        }

        protected void handle(Throwable t, Consumer<Throwable> next) {
            if (t instanceof DecoderException && t.getCause() instanceof SSLException && t.getMessage() != null && t.getMessage().contains("Received fatal alert")) {
                return;
            }
            next.accept(t);
        }
    }

    @Ordered(value=1)
    static class SuppressUnknownCAExceptions
    extends ExceptionEvaluator {
        public SuppressUnknownCAExceptions(ExceptionEvaluatorRegistry registry) {
            super(registry);
        }

        @Override
        public ErrorResponse evaluate(Throwable t, Acteur acteur, Page page, Event<?> evt) {
            if (t instanceof DecoderException && t.getCause() instanceof SSLException && t.getMessage() != null && t.getMessage().contains("Received fatal alert")) {
                evt.channel().close();
                return Err.gone("X");
            }
            return null;
        }
    }
}

