/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.annotations.GenericApplication;
import com.mastfrog.acteur.annotations.GenericApplicationModule;
import com.mastfrog.acteur.server.ActeurSslConfig;
import com.mastfrog.acteur.server.ServerModule;
import com.mastfrog.acteur.util.Server;
import com.mastfrog.giulius.DependenciesBuilder;
import com.mastfrog.giulius.InjectionInfo;
import com.mastfrog.giulius.SettingsBindings;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.settings.Settings;
import com.mastfrog.settings.SettingsBuilder;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLException;

public final class ServerBuilder {
    private final String namespace;
    private Class<? extends Application> appType;
    private final List<Settings> settingsList = new LinkedList<Settings>();
    private final List<Module> modules = new LinkedList<Module>();
    private final List<Class<? extends Module>> moduleClasses = new LinkedList<Class<? extends Module>>();
    private final Set<Class<?>> types = new HashSet();
    private final ReentrantScope scope;
    private boolean enableCors = true;
    private boolean enableHelp = false;
    private boolean mergeNamespaces;
    private SslContext sslContext;
    private final Set<SettingsBindings> settingsBindings = EnumSet.allOf(SettingsBindings.class);
    private Duration shutdownHookWaitMillis;

    public ServerBuilder(ReentrantScope scope) {
        this("defaults", scope);
    }

    public ServerBuilder(String namespace, ReentrantScope scope) {
        Checks.notNull((String)"namespace", (Object)namespace);
        Checks.notNull((String)"scope", (Object)scope);
        this.namespace = namespace;
        this.scope = scope;
    }

    public ServerBuilder() {
        this("defaults");
    }

    public ServerBuilder(String namespace) {
        Checks.notNull((String)"namespace", (Object)namespace);
        this.namespace = namespace;
        this.scope = new ReentrantScope((Provider)new InjectionInfo());
    }

    public ServerBuilder mergeNamespaces() {
        this.mergeNamespaces = true;
        return this;
    }

    public ServerBuilder applicationClass(Class<? extends Application> type) {
        if (this.appType != null) {
            throw new IllegalStateException("App type was already set to " + this.appType);
        }
        this.appType = type;
        return this;
    }

    public ServerBuilder sslConfig(SslContext context) {
        this.ssl();
        this.sslContext = context;
        return this;
    }

    public ServerBuilder ssl() {
        try {
            this.settingsList.add(new SettingsBuilder().add("ssl.enabled", true).build());
        }
        catch (IOException ex) {
            return (ServerBuilder)Exceptions.chuck((Throwable)ex);
        }
        return this;
    }

    public ServerBuilder add(Settings settings) {
        this.settingsList.add(settings);
        return this;
    }

    public ServerBuilder add(Module module) {
        this.modules.add(module);
        return this;
    }

    public ServerBuilder add(Class<? extends Module> module) {
        this.moduleClasses.add(module);
        return this;
    }

    public ServerBuilder withType(Class<?> ... types) {
        this.types.addAll(Arrays.asList(types));
        return this;
    }

    public ReentrantScope scope() {
        return this.scope;
    }

    public ServerBuilder enableHelp() {
        this.enableHelp = true;
        return this;
    }

    public ServerBuilder disableHelp() {
        this.enableHelp = false;
        return this;
    }

    public ServerBuilder enableCORS() {
        this.enableCors = true;
        return this;
    }

    public ServerBuilder disableCORS() {
        this.enableCors = false;
        return this;
    }

    public ServerBuilder disableBindings(SettingsBindings ... bindings) {
        EnumSet<SettingsBindings> toRemove = EnumSet.noneOf(SettingsBindings.class);
        for (SettingsBindings b : bindings) {
            toRemove.add(b);
        }
        this.settingsBindings.removeAll(toRemove);
        return this;
    }

    public ServerBuilder enableOnlyBindingsFor(SettingsBindings ... bindings) {
        EnumSet<SettingsBindings> newSet = EnumSet.noneOf(SettingsBindings.class);
        for (SettingsBindings b : bindings) {
            newSet.add(b);
        }
        this.settingsBindings.clear();
        this.settingsBindings.addAll(newSet);
        return this;
    }

    public Server build() throws IOException {
        return (Server)this.toDependenciesBuilder().build().getInstance(Server.class);
    }

    public ServerBuilder withShutdownHookWaitMillis(Duration dur) {
        return this;
    }

    public DependenciesBuilder toDependenciesBuilder() throws IOException {
        SettingsBuilder sb = new SettingsBuilder(this.namespace);
        sb.addDefaultLocations();
        for (Settings s : this.settingsList) {
            sb.add(s);
        }
        Settings settings = sb.build();
        ScopeProvider appModule = this.appModule(settings);
        DependenciesBuilder db = new DependenciesBuilder().add(new Module[]{appModule});
        if (this.shutdownHookWaitMillis != null) {
            db.withShutdownHookExecutorAwaitDuration(this.shutdownHookWaitMillis);
        } else if (!Boolean.getBoolean("unit.test")) {
            db.withShutdownHookExecutorAwaitDuration(Duration.ofMinutes(1L));
        }
        db.enableOnlyBindingsFor(this.settingsBindings.toArray(new SettingsBindings[this.settingsBindings.size()]));
        db.add(settings, this.namespace);
        db.add(settings, "defaults");
        for (Module module : this.modules) {
            db.add(new Module[]{module});
        }
        for (Class clazz : this.moduleClasses) {
            db.add(new Module[]{this.instantiateModule(clazz, appModule, settings)});
        }
        db.add(new Module[]{new CorsAndHelpModule(this.enableCors, this.enableHelp)});
        if (this.mergeNamespaces) {
            db.mergeNamespaces();
        }
        return db;
    }

    private ScopeProvider appModule(Settings settings) {
        if (this.appType == null || GenericApplication.class.isAssignableFrom(this.appType)) {
            return this.createGenericApplicationModule(settings, this.types, this.sslContext);
        }
        return ServerBuilder.createModule(this.scope, this.appType, this.types, this.sslContext);
    }

    private static <T extends Application> TS<T> createModule(ReentrantScope scope, Class<T> appType, Set<Class<?>> toBind, SslContext sslContext) {
        return new TS<T>(scope, appType, toBind, sslContext);
    }

    private GS<?> createGenericApplicationModule(Settings settings, Set<Class<?>> toBind, SslContext ctx) {
        Class c = this.appType == null ? GenericApplication.class : this.appType;
        return ServerBuilder.createGenericApplicationModule(this.scope, c, settings, toBind, ctx);
    }

    private static <T extends GenericApplication> GS<T> createGenericApplicationModule(ReentrantScope scope, Class<T> type, Settings settings, Set<Class<?>> toBind, SslContext ctx) {
        return new GS<T>(scope, type, settings, toBind, ctx);
    }

    private Module instantiateModule(Class<? extends Module> module, ScopeProvider s, Settings settings) {
        try {
            return GenericApplicationModule.instantiateModule(module, settings, s.scope());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            return (Module)Exceptions.chuck((Throwable)ex);
        }
    }

    private static interface ScopeProvider
    extends Module {
        public ReentrantScope scope();
    }

    static class CorsAndHelpModule
    extends GenericApplication.GenericApplicationSettings
    implements Module {
        public CorsAndHelpModule(boolean corsEnabled, boolean helpEnabled) {
            super(corsEnabled, helpEnabled);
        }

        public void configure(Binder binder) {
            binder.bind(GenericApplication.GenericApplicationSettings.class).toInstance((Object)this);
        }
    }

    private static final class GS<T extends GenericApplication>
    extends GenericApplicationModule<T>
    implements ScopeProvider {
        private final Set<Class<?>> toBind;
        private SslContext ctx;

        public GS(ReentrantScope scope, Class<T> appType, Settings settings, Set<Class<?>> toBind, SslContext ctx) {
            super(scope, settings, appType, new Class[0]);
            this.toBind = toBind;
            this.ctx = ctx;
        }

        public GS(Settings settings, Set<Class<?>> toBind) {
            super(settings);
            this.toBind = toBind;
        }

        @Override
        protected void configure() {
            super.configure();
            Class[] types = this.toBind.toArray(new Class[this.toBind.size()]);
            this.scope.bindTypes(this.binder(), types);
            if (this.ctx != null) {
                this.bind(ActeurSslConfig.class).toInstance((Object)new SslConfigImpl(this.ctx));
            }
        }

        @Override
        public ReentrantScope scope() {
            return this.scope;
        }
    }

    private static final class TS<T extends Application>
    extends ServerModule<T>
    implements ScopeProvider {
        private final Set<Class<?>> toBind;
        private final SslContext ctx;

        TS(ReentrantScope scope, Class<T> appType, Set<Class<?>> toBind, SslContext ctx) {
            super(scope, appType, -1, -1, -1);
            this.toBind = toBind;
            this.ctx = ctx;
        }

        @Override
        protected void configure() {
            super.configure();
            Class[] types = this.toBind.toArray(new Class[this.toBind.size()]);
            this.scope.bindTypes(this.binder(), types);
            if (this.ctx != null) {
                this.bind(ActeurSslConfig.class).toInstance((Object)new SslConfigImpl(this.ctx));
            }
        }

        @Override
        public ReentrantScope scope() {
            return this.scope;
        }
    }

    static final class SslConfigImpl
    extends ActeurSslConfig {
        private final SslContext ctx;

        public SslConfigImpl(SslContext ctx) {
            this.ctx = ctx;
        }

        @Override
        protected SslContext createSslContext() throws CertificateException, SSLException {
            return this.ctx;
        }
    }
}

