/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.mastfrog.acteur.server.EventLoopFactory;
import com.mastfrog.acteur.server.PipelineFactoryImpl;
import com.mastfrog.acteur.server.ServerLifecycleHook;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.acteur.util.Server;
import com.mastfrog.acteur.util.ServerControl;
import com.mastfrog.settings.Settings;
import com.mastfrog.shutdown.hooks.ShutdownHookRegistry;
import com.mastfrog.util.preconditions.Exceptions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;

final class ServerImpl
implements Server {
    private static final int DEFAULT_PORT = 8123;
    private final ChannelInitializer<SocketChannel> pipelineFactory;
    private int port = 8123;
    private final Provider<EventLoopFactory> loopFactory;
    private final String applicationName;
    private final ShutdownHookRegistry registry;
    private final Provider<ServerBootstrap> bootstrapProvider;
    private final Provider<ApplicationControl> app;
    private final Settings settings;
    private final ServerLifecycleHook.Registry hooks;

    @Inject
    ServerImpl(ChannelInitializer<SocketChannel> pipelineFactory, Provider<EventLoopFactory> loopFactory, @Named(value="application") String applicationName, Provider<ServerBootstrap> bootstrapProvider, ShutdownHookRegistry registry, Provider<ApplicationControl> app, Settings settings, ServerLifecycleHook.Registry hooks) {
        this.port = settings.getInt("port", 8123);
        this.pipelineFactory = pipelineFactory;
        this.loopFactory = loopFactory;
        this.applicationName = applicationName;
        this.bootstrapProvider = bootstrapProvider;
        this.registry = registry;
        this.app = app;
        this.settings = settings;
        this.hooks = hooks;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.applicationName + " on port " + this.port;
    }

    public ServerControl start(int port) throws IOException {
        this.port = port;
        ServerControlImpl result = null;
        CountDownLatch afterStart = new CountDownLatch(1);
        try {
            result = new ServerControlImpl(port, afterStart, this.loopFactory, this.registry, ServerImpl.isExitOnBindFailure(this.settings));
            String bindAddress = this.settings.getString("server.bind.interface.address", this.settings.getString("bindAddress"));
            InetAddress addr = null;
            if (bindAddress != null) {
                addr = InetAddress.getByName(bindAddress);
            }
            ServerBootstrap bootstrap = ((EventLoopFactory)this.loopFactory.get()).configureBootstrap((ServerBootstrap)this.bootstrapProvider.get()).childHandler(this.pipelineFactory);
            bootstrap = addr == null ? (ServerBootstrap)bootstrap.localAddress((SocketAddress)new InetSocketAddress(port)) : (ServerBootstrap)bootstrap.localAddress(addr, port);
            bootstrap.bind().addListener((GenericFutureListener)result).addListener((GenericFutureListener)this.hooks.listener());
            if (this.settings.getBoolean("acteur.debug", false)) {
                System.err.println("Starting " + this);
            }
            if (this.settings.getBoolean("cors.enabled", true)) {
                ((ApplicationControl)this.app.get()).enableDefaultCorsHandling();
            }
            afterStart.await();
            return result.throwIfFailure(null);
        }
        catch (InterruptedException ex) {
            ((ApplicationControl)this.app.get()).internalOnError(ex);
            afterStart.countDown();
            if (result != null) {
                return result.throwIfFailure(ex);
            }
            return (ServerControl)Exceptions.chuck((Throwable)ex);
        }
    }

    public ServerControl start() throws IOException {
        return this.start(this.port);
    }

    public ServerControl start(boolean ssl) throws IOException {
        ((PipelineFactoryImpl)this.pipelineFactory).useSsl = ssl;
        return this.start(this.port);
    }

    public ServerControl start(int port, boolean ssl) throws IOException {
        ((PipelineFactoryImpl)this.pipelineFactory).useSsl = ssl;
        return this.start(port);
    }

    static boolean isExitOnBindFailure(Settings settings) {
        return settings.getBoolean("system.exit.on.bind.failure", true);
    }

    private static class ServerControlImpl
    implements ServerControl,
    Runnable,
    ChannelFutureListener {
        private Channel localChannel;
        private final EventLoopGroup events;
        private final EventLoopGroup workers;
        private final int port;
        private final CountDownLatch afterStart;
        private final CountDownLatch waitClose = new CountDownLatch(1);
        private volatile boolean shuttingDown;
        private final ShutdownHookRegistry registry;
        private final boolean exitOnBindFailure;
        private Throwable failure;
        boolean initialized;
        boolean success;

        ServerControlImpl(int port, CountDownLatch afterStart, Provider<EventLoopFactory> loopFactory, ShutdownHookRegistry registry, boolean exitOnBindFailure) {
            this.port = port;
            this.afterStart = afterStart;
            this.events = ((EventLoopFactory)loopFactory.get()).getEventGroup();
            this.workers = ((EventLoopFactory)loopFactory.get()).getWorkerGroup();
            this.registry = registry;
            this.exitOnBindFailure = exitOnBindFailure;
        }

        public void shutdown(boolean immediately, long timeout, TimeUnit unit) throws InterruptedException {
            this.shutdown(timeout, unit, true);
        }

        private synchronized boolean isTerminated() {
            return this.localChannel == null ? true : !this.localChannel.isOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown(long timeout, TimeUnit unit, boolean await) throws InterruptedException {
            if (this.shuttingDown) {
                this.await(timeout, unit);
                return;
            }
            this.shuttingDown = true;
            try {
                Channel ch;
                ServerControlImpl serverControlImpl = this;
                synchronized (serverControlImpl) {
                    ch = this.localChannel;
                }
                if (ch != null && ch.isOpen()) {
                    if (await) {
                        ch.close().await(timeout, unit);
                    } else {
                        ch.close();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (await) {
                    this.events.shutdownGracefully(0L, timeout / 3L, unit);
                    this.workers.shutdownGracefully(0L, timeout / 3L, unit);
                } else {
                    this.events.shutdownGracefully();
                    this.workers.shutdownGracefully();
                }
                this.shuttingDown = false;
                ServerControlImpl serverControlImpl = this;
                synchronized (serverControlImpl) {
                    this.localChannel = null;
                }
                this.afterStart.countDown();
            }
        }

        public void shutdown(boolean immediately) throws InterruptedException {
            this.shutdown(1L, TimeUnit.SECONDS, true);
            this.await();
        }

        public void await() throws InterruptedException {
            try {
                this.waitClose.await();
            }
            catch (InterruptedException ex) {
                return;
            }
        }

        public void awaitUninterruptibly() {
            while (!this.isTerminated()) {
                try {
                    this.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            this.waitClose.await(nanosTimeout, TimeUnit.NANOSECONDS);
            return 0L;
        }

        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            this.waitClose.await(time, unit);
            return this.isTerminated();
        }

        public boolean awaitUntil(Date deadline) throws InterruptedException {
            long howLong = deadline.getTime() - System.currentTimeMillis();
            if (howLong > 0L) {
                return this.await(howLong, TimeUnit.MILLISECONDS);
            }
            return this.isTerminated();
        }

        public void signal() {
            this.signalAll();
        }

        public void signalAll() {
            try {
                this.shutdown(0L, TimeUnit.MILLISECONDS, false);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ServerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void run() {
            try {
                if (!this.isTerminated()) {
                    this.shutdown(0L, TimeUnit.MILLISECONDS, false);
                }
            }
            catch (InterruptedException ex) {
                Exceptions.chuck((Throwable)ex);
            }
        }

        public int getPort() {
            return this.port;
        }

        public synchronized void operationComplete(ChannelFuture f) throws Exception {
            if (!this.initialized) {
                this.initialized = true;
                this.failure = f.cause();
                if (this.failure == null) {
                    this.localChannel = f.channel();
                    this.registry.add((Runnable)new WeakRunnable(this));
                    this.success = true;
                } else {
                    this.failure.printStackTrace();
                    this.events.shutdownGracefully();
                    this.workers.shutdownGracefully();
                }
                this.afterStart.countDown();
                f.channel().closeFuture().addListener((GenericFutureListener)this);
            } else {
                this.waitClose.countDown();
            }
        }

        public synchronized ServerControl throwIfFailure(Throwable t) {
            if (this.failure != null) {
                if (this.failure instanceof BindException && this.exitOnBindFailure) {
                    this.failure.printStackTrace(System.err);
                    System.err.flush();
                    if (!Boolean.getBoolean("unit.test") && System.getProperty("forkNumber") == null) {
                        System.exit(1);
                    } else {
                        System.err.println("System.exit() skipped - in test");
                    }
                }
                if (t != null) {
                    this.failure.addSuppressed(t);
                }
                Exceptions.chuck((Throwable)this.failure);
            }
            return this;
        }
    }

    private static class WeakRunnable
    implements Runnable {
        private final Reference<Runnable> delegate;

        WeakRunnable(Runnable real) {
            this.delegate = new WeakReference<Runnable>(real);
        }

        @Override
        public void run() {
            Runnable real = this.delegate.get();
            if (real != null) {
                real.run();
            }
        }
    }
}

