/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.Singleton;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.util.preconditions.Checks;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;

public abstract class ServerLifecycleHook {
    protected ServerLifecycleHook(Registry reg) {
        reg.register(this);
    }

    protected abstract void onStartup(Application var1, Channel var2) throws Exception;

    protected void onShutdown() throws Exception {
    }

    @Singleton
    public static final class Registry {
        private final List<ServerLifecycleHook> hooks = new ArrayList<ServerLifecycleHook>();
        private final List<ServerLifecycleHook> forShutdown = new ArrayList<ServerLifecycleHook>();
        private final L l = new L();
        private final S s = new S();
        private final Provider<Application> applicationProvider;
        private ChannelFuture future;
        private final Provider<ApplicationControl> ctrl;
        private volatile boolean startupExceptionsThrown;

        @Inject
        Registry(Provider<Application> applicationProvider, Provider<ApplicationControl> ctrl) {
            this.applicationProvider = applicationProvider;
            this.ctrl = ctrl;
        }

        synchronized Registry register(ServerLifecycleHook hook) {
            if (this.future != null) {
                throw new IllegalStateException("ServerStartupHook " + hook + " being registered *after* startup - not bound as an eager singleton?");
            }
            this.hooks.add((ServerLifecycleHook)Checks.notNull((String)"hook", (Object)hook));
            return this;
        }

        ChannelFutureListener listener() {
            return this.l;
        }

        public boolean startupExceptionsThrown() {
            return this.startupExceptionsThrown;
        }

        synchronized void runHooks(ChannelFuture fut) {
            this.future = fut;
            if (!this.hooks.isEmpty()) {
                Channel channel = fut.channel();
                channel.closeFuture().addListener((GenericFutureListener)this.s);
                Application application = (Application)this.applicationProvider.get();
                ArrayList<ServerLifecycleHook> local = new ArrayList<ServerLifecycleHook>(this.hooks);
                this.hooks.clear();
                for (ServerLifecycleHook hook : local) {
                    try {
                        hook.onStartup(application, channel);
                        this.forShutdown.add(hook);
                    }
                    catch (Exception ex) {
                        this.startupExceptionsThrown = true;
                        ((ApplicationControl)this.ctrl.get()).internalOnError(ex);
                    }
                }
            }
        }

        synchronized void onShutdown(ChannelFuture fut) {
            this.future = fut;
            if (!this.forShutdown.isEmpty()) {
                for (ServerLifecycleHook hook : this.forShutdown) {
                    try {
                        hook.onShutdown();
                    }
                    catch (Exception ex) {
                        ((ApplicationControl)this.ctrl.get()).internalOnError(ex);
                    }
                }
            }
        }

        private class L
        implements ChannelFutureListener {
            private L() {
            }

            public void operationComplete(ChannelFuture f) throws Exception {
                if (f.isSuccess()) {
                    Registry.this.runHooks(f);
                }
            }
        }

        private class S
        implements ChannelFutureListener {
            private S() {
            }

            public void operationComplete(ChannelFuture f) throws Exception {
                Registry.this.onShutdown(f);
            }
        }
    }
}

