/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.BuiltInPageAnnotationHandler;
import com.mastfrog.acteur.Closables;
import com.mastfrog.acteur.DeferredComputationResult;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.ImplicitBindings;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.errors.Err;
import com.mastfrog.acteur.errors.ErrorResponse;
import com.mastfrog.acteur.errors.ExceptionEvaluator;
import com.mastfrog.acteur.errors.ExceptionEvaluatorRegistry;
import com.mastfrog.acteur.header.entities.BasicCredentials;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.request.HttpProtocolRequest;
import com.mastfrog.acteur.server.PipelineFactoryImpl;
import com.mastfrog.acteur.server.ServerBootstrapConfigurer;
import com.mastfrog.acteur.server.ServerImpl;
import com.mastfrog.acteur.server.UpstreamHandlerImpl;
import com.mastfrog.acteur.server.WebSocketEvent;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.acteur.util.ErrorHandler;
import com.mastfrog.acteur.util.HttpMethod;
import com.mastfrog.acteur.util.RequestID;
import com.mastfrog.acteur.util.Server;
import com.mastfrog.acteurbase.ActeurBaseModule;
import com.mastfrog.acteurbase.Chain;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.InjectionInfo;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.giulius.thread.ConventionalThreadSupplier;
import com.mastfrog.giulius.thread.ExecutorServiceBuilder;
import com.mastfrog.giulius.thread.ThreadModule;
import com.mastfrog.giulius.thread.ThreadPoolType;
import com.mastfrog.marshallers.netty.NettyContentMarshallers;
import com.mastfrog.settings.Settings;
import com.mastfrog.url.Path;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.Protocols;
import com.mastfrog.util.codec.Codec;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.ConfigurationError;
import com.mastfrog.util.strings.Strings;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMaxBytesRecvByteBufAllocator;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.netbeans.validation.api.InvalidInputException;

public class ServerModule<A extends Application>
extends AbstractModule {
    public static final AsciiString X_INTERNAL_COMPRESS = new AsciiString((CharSequence)"X-Internal-Compress");
    public static final HeaderValueType<CharSequence> X_INTERNAL_COMPRESS_HEADER = Headers.header((CharSequence)X_INTERNAL_COMPRESS);
    public static final String HTTP_COMPRESSION_LEVEL = "compression.level";
    public static final String HTTP_COMPRESSION_WINDOW_BITS = "compression.window.bits";
    public static final String HTTP_COMPRESSION_MEMORY_LEVEL = "compression.memory.level";
    public static final String HTTP_COMPRESSION_THRESHOLD = "compression.threshold";
    public static final String HTTP_COMPRESSION_CHECK_RESPONSE_CONTENT_TYPE = "compression.check.content.type";
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    public static final int DEFAULT_COMPRESSION_WINDOW_BITS = 15;
    public static final int DEFAULT_COMPRESSION_MEMORY_LEVEL = 8;
    public static final int DEFAULT_COMPRESSION_THRESHOLD = 256;
    public static final String SETTINGS_KEY_BIND_ADDRESS = "server.bind.interface.address";
    public static final String SETTINGS_KEY_BASE_PATH = "basepath";
    public static final String SETTINGS_KEY_URLS_HOST_NAME = "hostname";
    public static final String SETTINGS_KEY_URLS_EXTERNAL_PORT = "external.port";
    public static final String SETTINGS_KEY_URLS_EXTERNAL_SECURE_PORT = "external.secure.port";
    public static final String SETTINGS_KEY_GENERATE_SECURE_URLS = "secure.urls";
    public static final String SETTINGS_KEY_DISABLE_LEAK_DETECTOR = "disable.leak.detector";
    public static final boolean DEFAULT_DISABLE_LEAK_DETECTOR = true;
    public static final String SETTINGS_KEY_RENDER_STACK_TRACES = "render.stack.traces";
    public static final String SETTINGS_KEY_GENERATE_URLS_WITH_INET_ADDRESS_GET_LOCALHOST = "urls.use.inetaddress.localhost";
    public static final String BACKGROUND_THREAD_POOL_NAME = "background";
    public static final String WORKER_THREAD_POOL_NAME = "workers";
    public static final String SCOPED_WORKER_THREAD_POOL_NAME = "scopedWorkers";
    public static final String SCOPED_BACKGROUND_THREAD_POOL_NAME = "scopedBackground";
    public static final String BYTEBUF_ALLOCATOR_SETTINGS_KEY = "acteur.bytebuf.allocator";
    public static final String DIRECT_ALLOCATOR = "direct";
    public static final String HEAP_ALLOCATOR = "heap";
    public static final String POOLED_ALLOCATOR = "pooled";
    public static final String CUSTOMIZED_POOLED_ALLOCATOR = "pooled-custom";
    public static final String DIRECT_OR_HEAP_BY_PLATFORM = "directOrHeap";
    public static final String DEFAULT_ALLOCATOR = "pooled";
    public static final String WORKER_THREADS = "workers";
    public static final String EVENT_THREADS = "eventThreads";
    @Deprecated
    public static final String BACKGROUND_THREADS = "backgroundThreads";
    public static final String PORT = "port";
    public static final String HTTP_COMPRESSION = "httpCompression";
    public static final String MAX_CONTENT_LENGTH = "maxContentLength";
    public static final String DELAY_EXECUTOR = "delayExecutor";
    public static final String SETTINGS_KEY_DELAY_THREAD_POOL_THREADS = "delay.response.threads";
    private static final int DEFAULT_DELAY_THREADS = 2;
    public static final String SETTINGS_KEY_DECODE_REAL_IP = "decodeRealIP";
    public static final String SETTINGS_KEY_CORS_ENABLED = "cors.enabled";
    public static final String SETTINGS_KEY_USE_FORK_JOIN_POOL = "acteur.fork.join";
    public static final String SETTINGS_KEY_CORS_MAX_AGE_MINUTES = "cors.max.age.minutes";
    public static final String GUICE_BINDING_DEFAULT_CONTEXT_OBJECTS = "default.context.objects";
    public static final String SETTINGS_KEY_CORS_ALLOW_ORIGIN = "cors.allow.origin";
    public static final String SETTINGS_KEY_CORS_ALLOW_HEADERS = "cors.allow.headers";
    public static final String SETTINGS_KEY_CORS_REPLACE_ALLOW_HEADERS = "cors.replace.allow.headers";
    public static final String SETTINGS_KEY_CORS_ALLOW_CREDENTIALS = "cors.allow.credentials";
    public static final String SETTINGS_KEY_CORS_CACHE_CONTROL_MAX_AGE = "cors.cache.control.max.age.days";
    public static final boolean DEFAULT_CORS_ENABLED = true;
    public static final long DEFAULT_CORS_MAX_AGE_MINUTES = 5L;
    public static final boolean DEFAULT_CORS_ALLOW_CREDENTIALS = true;
    public static final String DEFAULT_CORS_ALLOW_ORIGIN = "*";
    public static final String SETTINGS_KEY_SSL_ENGINE = "ssl.engine";
    public static final String SETTINGS_KEY_SYSTEM_EXIT_ON_BIND_FAILURE = "system.exit.on.bind.failure";
    public static final String SETTINGS_KEY_SSL_ENABLED = "ssl.enabled";
    public static final String SETTINGS_KEY_WEBSOCKETS_ENABLED = "websocket.enabled";
    public static final String SETTINGS_KEY_SOCKET_TCP_NODELAY = "acteur.outbound.socket.tcp.nodelay";
    public static final String SETTINGS_KEY_SOCKET_CONNECT_TIMEOUT_MILLIS = "acteur.inbound.socket.connect.timeout.millis";
    public static final String SETTINGS_KEY_SOCKET_MAX_MESSAGES_PER_READ = "acteur.inbound.socket.max.messages.per.read";
    public static final String SETTINGS_KEY_SOCKET_MAX_MESSAGES_PER_INDIVIDUAL_READ = "acteur.inbound.socket.max.messages.per.individual.read";
    public static final String SETTINGS_KEY_SOCKET_SO_RCVBUF = "acteur.inbound.socket.rcvbuf.size";
    public static final String SETTINGS_KEY_SOCKET_SO_SNDBUF = "acteur.outbound.socket.sndbuf.size";
    public static final String SETTINGS_KEY_SOCKET_WRITE_SPIN_COUNT = "acteur.outbound.socket.write.spin.count";
    public static final boolean DEFAULT_TCP_NODELAY = true;
    public static final boolean DEFAULT_WEBSOCKET_ENABLED = false;
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_CACHE_ALIGNMENT = "custom.alloc.cache.alignment";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_USE_CACHE_ALL_THREADS = "custom.alloc.use.cache.all.threads";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_NORMAL_CACHE_SIZE = "custom.alloc.normal.cache.size";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_SMALL_CACHE_SIZE = "custom.alloc.small.cache.size";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_TINY_CACHE_SIZE = "custom.alloc.tiny.cache.size";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_MAX_ORDER = "custom.alloc.max.order";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_PAGE_SIZE = "custom.alloc.page.size";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_NUM_DIRECT_ARENAS = "custom.alloc.num.direct.arenas";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_NUM_HEAP_ARENAS = "custom.alloc.num.heap.arenas";
    public static final String SETTINGS_KEY_CUSTOM_ALLOC_PREFER_DIRECT = "custom.alloc.prefer.direct";
    public static final String SETTINGS_KEY_MAX_REQUEST_LINE_LENGTH = "max.request.line.length";
    public static final String SETTINGS_KEY_MAX_HEADER_BUFFER_SIZE = "max.header.buffer.size";
    public static final String SETTINGS_KEY_MAX_CHUNK_SIZE = "max.chunk.size";
    public static final String SETTINGS_KEY_CHARSET = "charset";
    static final AttributeKey<Boolean> SSL_ATTRIBUTE_KEY = AttributeKey.newInstance((String)"ssl");
    protected final Class<? extends A> appType;
    protected final ReentrantScope scope;
    private final int eventThreads;
    private final int workerThreads;
    private final int backgroundThreads;
    private final List<Module> otherModules = new ArrayList<Module>();
    private static final ConventionalThreadSupplier FTL_THREADS = new FastThreadLocalThreadSupplier();

    public ServerModule(Class<? extends A> appType, int workerThreadCount, int eventThreadCount, int backgroundThreadCount) {
        this(new ReentrantScope((Provider)new InjectionInfo()), appType, workerThreadCount, eventThreadCount, backgroundThreadCount);
    }

    public ServerModule(ReentrantScope scope, Class<? extends A> appType, int workerThreadCount, int eventThreadCount, int backgroundThreadCount) {
        if (!Application.class.isAssignableFrom(appType)) {
            throw new ClassCastException(appType.getName() + " is not a subclass of " + Application.class.getName());
        }
        this.appType = appType;
        this.workerThreads = workerThreadCount;
        this.eventThreads = eventThreadCount;
        this.backgroundThreads = backgroundThreadCount;
        this.scope = scope;
    }

    public ServerModule(Class<? extends A> appType) {
        this(appType, -1, -1, -1);
    }

    public ServerModule(ReentrantScope scope, Class<? extends A> appType) {
        this(scope, appType, -1, -1, -1);
    }

    public final ReentrantScope applicationScope() {
        return this.scope;
    }

    private ThreadModule configureThreadPools(ThreadModule threads) {
        this.configureThreadPool(threads, EVENT_THREADS);
        this.configureThreadPool(threads, "workers");
        this.configureThreadPool(threads, BACKGROUND_THREAD_POOL_NAME);
        this.configureThreadPool(threads, DELAY_EXECUTOR);
        return threads;
    }

    private void configureThreadPool(ThreadModule threads, String pool) {
        ExecutorServiceBuilder bldr = threads.builder(pool).daemon().withThreadSupplier(FTL_THREADS);
        switch (pool) {
            case "eventThreads": {
                bldr.withDefaultThreadCount(4).withThreadPriority(9).withThreadSupplier(FTL_THREADS).shutdownCoordination(ExecutorServiceBuilder.ShutdownBatch.LATE).eager();
                if (this.eventThreads <= 0) break;
                bldr.withExplicitThreadCount(this.eventThreads);
                break;
            }
            case "workers": {
                bldr.withDefaultThreadCount(16).workStealing().shutdownCoordination(ExecutorServiceBuilder.ShutdownBatch.LATE).eager();
                if (this.workerThreads <= 0) break;
                bldr.withExplicitThreadCount(this.workerThreads);
                break;
            }
            case "background": {
                bldr.withDefaultThreadCount(32).legacyThreadCountName(BACKGROUND_THREADS).workStealing();
                if (this.backgroundThreads <= 0) break;
                bldr.withExplicitThreadCount(this.backgroundThreads);
                break;
            }
            case "delayExecutor": {
                bldr.withDefaultThreadCount(8).withThreadPoolType(ThreadPoolType.SCHEDULED);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown thread pool binding " + pool);
            }
        }
        bldr.bind();
    }

    protected void configure() {
        this.bind(ZonedDateTime.class).toInstance((Object)ZonedDateTime.now());
        this.bind(Server.class).to(ServerImpl.class);
        this.bind(ReentrantScope.class).toInstance((Object)this.scope);
        this.bind(Application.class).to(this.appType).asEagerSingleton();
        this.bind(ChannelHandler.class).to(UpstreamHandlerImpl.class);
        this.bind(new CISC()).to(PipelineFactoryImpl.class);
        this.bind(ServerBootstrap.class).toProvider((Provider)new ServerBootstrapProvider((Provider<Settings>)this.binder().getProvider(Settings.class), (Provider<ByteBufAllocator>)this.binder().getProvider(ByteBufAllocator.class), (Provider<ServerBootstrapConfigurer>)this.binder().getProvider(ServerBootstrapConfigurer.class)));
        this.scope.bindTypes(this.binder(), new Class[]{Event.class, HttpEvent.class, RequestID.class, WebSocketEvent.class, Page.class, BasicCredentials.class, Closables.class, DeferredComputationResult.class});
        ImplicitBindings implicit = this.appType.getAnnotation(ImplicitBindings.class);
        if (implicit != null) {
            this.scope.bindTypes(this.binder(), (Class[])implicit.value());
        }
        this.install((Module)new ActeurBaseModule(this.scope));
        this.install((Module)this.configureThreadPools(new ThreadModule()));
        this.bind(Thread.UncaughtExceptionHandler.class).to(Uncaught.class);
        Provider workerProvider = this.getProvider(Key.get(ExecutorService.class, (Annotation)Names.named((String)EVENT_THREADS)));
        Provider backgroundProvider = this.getProvider(Key.get(ExecutorService.class, (Annotation)Names.named((String)BACKGROUND_THREAD_POOL_NAME)));
        this.bind(ExecutorService.class).annotatedWith((Annotation)Names.named((String)SCOPED_WORKER_THREAD_POOL_NAME)).toProvider(this.scope.wrapThreadPool(workerProvider));
        this.bind(ExecutorService.class).annotatedWith((Annotation)Names.named((String)SCOPED_BACKGROUND_THREAD_POOL_NAME)).toProvider(this.scope.wrapThreadPool(backgroundProvider));
        this.bind(Duration.class).toProvider(UptimeProvider.class);
        this.bind(new CKTL()).toProvider(CookiesProvider.class);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"application")).toInstance((Object)this.appType.getSimpleName());
        this.bind(ServerImpl.class).asEagerSingleton();
        for (Module m : this.otherModules) {
            this.install(m);
        }
        this.bind(Charset.class).toProvider(CharsetProvider.class);
        this.bind(ByteBufAllocator.class).toProvider(ByteBufAllocatorProvider.class);
        this.bind(new ETL()).toProvider(EventProvider.class).in((Scope)this.scope);
        this.bind(Codec.class).to(CodecImpl.class);
        this.bind(ApplicationControl.class).toProvider(ApplicationControlProvider.class).in(Scopes.SINGLETON);
        this.bind(ExceptionEvaluatorRegistry.class).asEagerSingleton();
        this.bind(InvalidInputExceptionEvaluator.class).asEagerSingleton();
        this.bind(Channel.class).toProvider(ChannelProvider.class);
        this.bind(HttpMethod.class).toProvider(MethodProvider.class);
        this.bind(Method.class).toProvider(MethodProvider2.class);
        this.bind(Path.class).toProvider(PathProvider.class);
        this.bind(BuiltInPageAnnotationHandler.class).asEagerSingleton();
        this.bind(new CL()).toProvider(ChainProvider.class);
        this.bind(NettyContentMarshallers.class).toProvider(MarshallersProvider.class).in(Scopes.SINGLETON);
        this.bind(SslProvider.class).toProvider(SSLEngineProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Set<io.netty.handler.codec.http.cookie.Cookie>>(){}).toProvider(CookiesProvider2.class);
        this.bind(Protocol.class).toProvider(ProtocolProvider.class);
        this.bind(WebSocketFrame.class).toProvider(WebSocketFrameProvider.class);
        this.bind(HttpProtocolRequest.class).toProvider(HttpProtocolRequestProvider.class);
        this.bind(ClientDisconnectErrors.class).asEagerSingleton();
    }

    public ServerModule<A> add(Module module) {
        this.otherModules.add(module);
        return this;
    }

    @Deprecated
    protected ServerBootstrap configureServerBootstrap(ServerBootstrap bootstrap, Settings settings) {
        return bootstrap;
    }

    private static ByteBufAllocator createCustomPooledAllocator(Settings settings) {
        boolean preferDirect = settings.getBoolean(SETTINGS_KEY_CUSTOM_ALLOC_PREFER_DIRECT, true);
        int nHeapArena = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_NUM_HEAP_ARENAS, PooledByteBufAllocator.DEFAULT.numHeapArenas());
        int nDirectArena = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_NUM_DIRECT_ARENAS, PooledByteBufAllocator.DEFAULT.numDirectArenas());
        int pageSize = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_PAGE_SIZE, PooledByteBufAllocator.defaultPageSize());
        int maxOrder = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_MAX_ORDER, PooledByteBufAllocator.defaultMaxOrder());
        int tinyCacheSize = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_TINY_CACHE_SIZE, PooledByteBufAllocator.defaultTinyCacheSize());
        int smallCacheSize = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_SMALL_CACHE_SIZE, PooledByteBufAllocator.defaultSmallCacheSize());
        int normalCacheSize = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_NORMAL_CACHE_SIZE, PooledByteBufAllocator.defaultNormalCacheSize());
        boolean useCacheForAllThreads = settings.getBoolean(SETTINGS_KEY_CUSTOM_ALLOC_USE_CACHE_ALL_THREADS, PooledByteBufAllocator.defaultUseCacheForAllThreads());
        int directMemoryCacheAlignment = settings.getInt(SETTINGS_KEY_CUSTOM_ALLOC_CACHE_ALIGNMENT, 0);
        return new PooledByteBufAllocator(preferDirect, nHeapArena, nDirectArena, pageSize, maxOrder, tinyCacheSize, smallCacheSize, normalCacheSize, useCacheForAllThreads, directMemoryCacheAlignment);
    }

    protected void onInit(Settings settings) {
    }

    protected void onBeforeStart(Server server, Dependencies deps) {
    }

    protected void onAfterStart(Server server, Dependencies deps) {
    }

    private static class CISC
    extends TypeLiteral<ChannelInitializer<SocketChannel>> {
        private CISC() {
        }
    }

    private final class ServerBootstrapProvider
    implements Provider<ServerBootstrap> {
        private final Provider<Settings> settings;
        private final Provider<ByteBufAllocator> allocator;
        private final Provider<ServerBootstrapConfigurer> bootstrapConfigurer;

        public ServerBootstrapProvider(Provider<Settings> settings, Provider<ByteBufAllocator> allocator, Provider<ServerBootstrapConfigurer> bootstrapConfigurer) {
            this.settings = settings;
            this.allocator = allocator;
            this.bootstrapConfigurer = bootstrapConfigurer;
        }

        public ServerBootstrap get() {
            ServerBootstrap result = new ServerBootstrap();
            ByteBufAllocator alloc = (ByteBufAllocator)this.allocator.get();
            Settings settings = (Settings)this.settings.get();
            result.option(ChannelOption.ALLOCATOR, (Object)alloc);
            result.childOption(ChannelOption.ALLOCATOR, (Object)alloc);
            result.childOption(ChannelOption.TCP_NODELAY, (Object)settings.getBoolean(ServerModule.SETTINGS_KEY_SOCKET_TCP_NODELAY, true));
            settings.ifIntPresent(ServerModule.SETTINGS_KEY_SOCKET_MAX_MESSAGES_PER_READ, maxOverall -> settings.ifIntPresent(ServerModule.SETTINGS_KEY_SOCKET_MAX_MESSAGES_PER_INDIVIDUAL_READ, maxIndividual -> result.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new DefaultMaxBytesRecvByteBufAllocator(Checks.nonNegative((String)ServerModule.SETTINGS_KEY_SOCKET_MAX_MESSAGES_PER_READ, (int)maxOverall), Checks.nonNegative((String)ServerModule.SETTINGS_KEY_SOCKET_MAX_MESSAGES_PER_INDIVIDUAL_READ, (int)maxIndividual)))));
            settings.ifIntPresent(ServerModule.SETTINGS_KEY_SOCKET_SO_RCVBUF, val -> result.option(ChannelOption.SO_SNDBUF, (Object)Checks.nonNegative((String)ServerModule.SETTINGS_KEY_SOCKET_SO_RCVBUF, (int)val)));
            settings.ifIntPresent(ServerModule.SETTINGS_KEY_SOCKET_SO_SNDBUF, val -> result.childOption(ChannelOption.SO_SNDBUF, (Object)Checks.nonNegative((String)ServerModule.SETTINGS_KEY_SOCKET_SO_SNDBUF, (int)val)));
            settings.ifIntPresent(ServerModule.SETTINGS_KEY_SOCKET_CONNECT_TIMEOUT_MILLIS, val -> result.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Checks.nonNegative((String)ServerModule.SETTINGS_KEY_SOCKET_CONNECT_TIMEOUT_MILLIS, (int)val)));
            settings.ifIntPresent(ServerModule.SETTINGS_KEY_SOCKET_WRITE_SPIN_COUNT, val -> result.childOption(ChannelOption.WRITE_SPIN_COUNT, (Object)Checks.greaterThanZero((String)ServerModule.SETTINGS_KEY_SOCKET_WRITE_SPIN_COUNT, (int)val)));
            return ((ServerBootstrapConfigurer)this.bootstrapConfigurer.get()).configureServerBootstrap(ServerModule.this.configureServerBootstrap(result, settings), settings);
        }
    }

    static final class Uncaught
    implements Thread.UncaughtExceptionHandler {
        private final Provider<ApplicationControl> ctrl;

        @Inject
        Uncaught(Provider<ApplicationControl> ctrl) {
            this.ctrl = ctrl;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ((ApplicationControl)this.ctrl.get()).internalOnError(e);
        }
    }

    private static class UptimeProvider
    implements Provider<Duration> {
        private final ZonedDateTime dt;

        @Inject
        UptimeProvider(ZonedDateTime dt) {
            this.dt = dt;
        }

        public Duration get() {
            return Duration.between(this.dt, ZonedDateTime.now());
        }
    }

    private static class CKTL
    extends TypeLiteral<Set<Cookie>> {
        private CKTL() {
        }
    }

    private static final class CookiesProvider
    implements Provider<Set<Cookie>> {
        private final Provider<HttpEvent> ev;

        @Inject
        public CookiesProvider(Provider<HttpEvent> ev) {
            this.ev = ev;
        }

        public Set<Cookie> get() {
            Set result;
            HttpEvent evt = (HttpEvent)this.ev.get();
            String h = evt.header(HttpHeaderNames.COOKIE.toString());
            if (h != null && (result = CookieDecoder.decode((String)h)) != null) {
                return result;
            }
            return Collections.emptySet();
        }
    }

    @Singleton
    private static final class CharsetProvider
    implements Provider<Charset> {
        private final Charset charset;

        @Inject
        CharsetProvider(Settings settings) {
            String set = settings.getString(ServerModule.SETTINGS_KEY_CHARSET);
            this.charset = set == null ? CharsetUtil.UTF_8 : Charset.forName(set);
        }

        public Charset get() {
            return this.charset;
        }
    }

    @Singleton
    private static final class ByteBufAllocatorProvider
    implements Provider<ByteBufAllocator> {
        private final ByteBufAllocator allocator;

        @Inject
        public ByteBufAllocatorProvider(Settings settings) {
            UnpooledByteBufAllocator result;
            String s = settings.getString(ServerModule.BYTEBUF_ALLOCATOR_SETTINGS_KEY, "pooled");
            boolean disableLeakDetector = settings.getBoolean(ServerModule.SETTINGS_KEY_DISABLE_LEAK_DETECTOR, true);
            switch (s) {
                case "directOrHeap": {
                    result = UnpooledByteBufAllocator.DEFAULT;
                    break;
                }
                case "direct": {
                    result = new UnpooledByteBufAllocator(true, disableLeakDetector);
                    break;
                }
                case "heap": {
                    result = new UnpooledByteBufAllocator(false, disableLeakDetector);
                    break;
                }
                case "pooled": {
                    result = PooledByteBufAllocator.DEFAULT;
                    break;
                }
                case "pooled-custom": {
                    result = ServerModule.createCustomPooledAllocator(settings);
                    break;
                }
                default: {
                    throw new ConfigurationError("Unknown value for acteur.bytebuf.allocator '" + s + "'; valid values are " + ServerModule.DIRECT_ALLOCATOR + ", " + ServerModule.HEAP_ALLOCATOR + ", " + "pooled");
                }
            }
            this.allocator = result;
        }

        public ByteBufAllocator get() {
            return this.allocator;
        }
    }

    private static final class ETL
    extends TypeLiteral<Event<?>> {
        private ETL() {
        }
    }

    private static final class EventProvider
    implements Provider<Event<?>> {
        private final Provider<Event> eventProvider;

        @Inject
        EventProvider(Provider<Event> eventProvider) {
            this.eventProvider = eventProvider;
        }

        public Event<?> get() {
            return (Event)this.eventProvider.get();
        }
    }

    static class CodecImpl
    implements Codec {
        private final Provider<ObjectMapper> mapper;

        @Inject
        public CodecImpl(Provider<ObjectMapper> mapper) {
            this.mapper = mapper;
        }

        public <T> String writeValueAsString(T object) throws IOException {
            return ((ObjectMapper)this.mapper.get()).writeValueAsString(object);
        }

        public <T> void writeValue(T object, OutputStream out) throws IOException {
            ((ObjectMapper)this.mapper.get()).writeValue(out, object);
        }

        public <T> T readValue(InputStream byteBufInputStream, Class<T> type) throws IOException {
            return (T)((ObjectMapper)this.mapper.get()).readValue(byteBufInputStream, type);
        }

        public <T> byte[] writeValueAsBytes(T object) throws IOException {
            return ((ObjectMapper)this.mapper.get()).writeValueAsBytes(object);
        }
    }

    static class ApplicationControlProvider
    implements Provider<ApplicationControl> {
        private final ApplicationControl control;

        @Inject
        public ApplicationControlProvider(Provider<Application> app) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Application a = (Application)app.get();
            java.lang.reflect.Method method = Application.class.getDeclaredMethod("control", new Class[0]);
            method.setAccessible(true);
            this.control = (ApplicationControl)method.invoke((Object)a, new Object[0]);
        }

        public ApplicationControl get() {
            return this.control;
        }
    }

    private static final class InvalidInputExceptionEvaluator
    extends ExceptionEvaluator {
        @Inject
        public InvalidInputExceptionEvaluator(ExceptionEvaluatorRegistry registry) {
            super(registry);
        }

        @Override
        public ErrorResponse evaluate(Throwable t, Acteur acteur, Page page, Event<?> evt) {
            if (t instanceof InvalidInputException) {
                InvalidInputException iie = (InvalidInputException)t;
                return Err.badRequest(iie.getProblems().toString());
            }
            return null;
        }
    }

    private static final class ChannelProvider
    implements Provider<Channel> {
        private final Provider<HttpEvent> evt;

        @Inject
        ChannelProvider(Provider<HttpEvent> evt) {
            this.evt = evt;
        }

        public Channel get() {
            return ((HttpEvent)this.evt.get()).channel();
        }
    }

    private static final class MethodProvider
    implements Provider<HttpMethod> {
        private final Provider<HttpEvent> evt;

        @Inject
        MethodProvider(Provider<HttpEvent> evt) {
            this.evt = evt;
        }

        public HttpMethod get() {
            return ((HttpEvent)this.evt.get()).method();
        }
    }

    private static final class MethodProvider2
    implements Provider<Method> {
        private final Provider<HttpEvent> evt;

        @Inject
        MethodProvider2(Provider<HttpEvent> evt) {
            this.evt = evt;
        }

        public Method get() {
            HttpEvent e = (HttpEvent)this.evt.get();
            if (e == null) {
                return null;
            }
            return e == null || !(e.method() instanceof Method) ? null : (Method)((HttpEvent)this.evt.get()).method();
        }
    }

    private static final class PathProvider
    implements Provider<Path> {
        private final Provider<HttpEvent> evt;

        @Inject
        PathProvider(Provider<HttpEvent> evt) {
            this.evt = evt;
        }

        public Path get() {
            return ((HttpEvent)this.evt.get()).path();
        }
    }

    static class CL
    extends TypeLiteral<Chain<Acteur, ? extends Chain<Acteur, ?>>> {
        CL() {
        }
    }

    static class ChainProvider
    implements Provider<Chain<Acteur, ? extends Chain<Acteur, ?>>> {
        private final Provider<Chain> chain;

        @Inject
        ChainProvider(Provider<Chain> chain) {
            this.chain = chain;
        }

        public Chain<Acteur, ? extends Chain<Acteur, ?>> get() {
            return (Chain)this.chain.get();
        }
    }

    private static final class MarshallersProvider
    implements Provider<NettyContentMarshallers> {
        final NettyContentMarshallers marshallers;

        @Inject
        public MarshallersProvider(ObjectMapper mapper) {
            this.marshallers = NettyContentMarshallers.getDefault((ObjectMapper)mapper);
        }

        public NettyContentMarshallers get() {
            return this.marshallers;
        }
    }

    private static final class SSLEngineProvider
    implements Provider<SslProvider> {
        private final SslProvider engine;

        @Inject
        SSLEngineProvider(Settings settings) {
            String name = settings.getString(ServerModule.SETTINGS_KEY_SSL_ENGINE);
            this.engine = name == null ? SslProvider.JDK : SslProvider.valueOf((String)name);
        }

        public SslProvider get() {
            return this.engine;
        }
    }

    private static final class CookiesProvider2
    implements Provider<Set<io.netty.handler.codec.http.cookie.Cookie>> {
        private final Provider<HttpEvent> ev;

        @Inject
        public CookiesProvider2(Provider<HttpEvent> ev) {
            this.ev = ev;
        }

        public Set<io.netty.handler.codec.http.cookie.Cookie> get() {
            HttpEvent evt = (HttpEvent)this.ev.get();
            Object[] cookies = (io.netty.handler.codec.http.cookie.Cookie[])evt.header(Headers.COOKIE_B);
            return cookies == null || cookies.length == 0 ? Collections.emptySet() : CollectionUtils.setOf((Object[])cookies);
        }
    }

    private static final class ProtocolProvider
    implements Provider<Protocol> {
        private final Provider<Channel> channelProvider;
        private final Provider<HttpEvent> evt;

        @Inject
        ProtocolProvider(Provider<Channel> channel, Provider<HttpEvent> evt) {
            this.channelProvider = channel;
            this.evt = evt;
        }

        public Protocol get() {
            Channel ch = (Channel)this.channelProvider.get();
            Attribute sslAttr = ch.attr(SSL_ATTRIBUTE_KEY);
            if (sslAttr != null && ((Boolean)sslAttr.get()).booleanValue()) {
                return Protocols.HTTPS;
            }
            CharSequence seq = (CharSequence)((HttpEvent)this.evt.get()).header(Headers.X_FORWARDED_PROTO);
            if (seq != null && Strings.charSequencesEqual((CharSequence)seq, (CharSequence)Protocols.HTTPS.name(), (boolean)true)) {
                return Protocols.HTTPS;
            }
            return Protocols.HTTP;
        }
    }

    private static final class WebSocketFrameProvider
    implements Provider<WebSocketFrame> {
        private final Provider<Event> evt;

        @Inject
        public WebSocketFrameProvider(Provider<Event> evt) {
            this.evt = evt;
        }

        public WebSocketFrame get() {
            Event evt = (Event)this.evt.get();
            if (evt instanceof WebSocketEvent) {
                return ((WebSocketEvent)evt).request();
            }
            throw new IllegalStateException("No web socket event in scope");
        }
    }

    private static class HttpProtocolRequestProvider
    implements Provider<HttpProtocolRequest> {
        private final Provider<Event<?>> eventProvider;

        @Inject
        HttpProtocolRequestProvider(Provider<Event<?>> eventProvider) {
            this.eventProvider = eventProvider;
        }

        public HttpProtocolRequest get() {
            Event evt = (Event)this.eventProvider.get();
            if (evt instanceof HttpProtocolRequest) {
                return (HttpProtocolRequest)evt;
            }
            return null;
        }
    }

    private static class ClientDisconnectErrors
    extends ErrorHandler.Typed<SocketException> {
        private final boolean inTest = Boolean.getBoolean("unit.test");

        @Inject
        ClientDisconnectErrors(ErrorHandler.Registry handlers) {
            super(handlers, SocketException.class, true);
        }

        protected boolean doHandle(SocketException t) {
            if (this.inTest) {
                return false;
            }
            return "Connection reset".equals(t.getMessage());
        }

        protected int ordinal() {
            return 0x7FFFFFFE;
        }
    }

    static final class FastThreadLocalThreadSupplier
    implements ConventionalThreadSupplier {
        FastThreadLocalThreadSupplier() {
        }

        public Thread newThread(ThreadGroup group, Runnable run, Settings settings, int stackSize, String bindingName, String threadName) {
            int stack = this.findStackSize(settings, stackSize, bindingName);
            if (stack <= 0) {
                return new FastThreadLocalThread(group, run, threadName);
            }
            return new FastThreadLocalThread(group, run, threadName, (long)stack);
        }
    }

    static final class NoOpServerBootstrapConfigurer
    implements ServerBootstrapConfigurer {
        @Inject
        NoOpServerBootstrapConfigurer() {
        }

        @Override
        public ServerBootstrap configureServerBootstrap(ServerBootstrap bootstrap, Settings settings) {
            return bootstrap;
        }
    }
}

