/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.google.inject.Singleton;
import com.mastfrog.acteur.ContentConverter;
import com.mastfrog.acteur.server.EventImpl;
import com.mastfrog.acteur.server.PathFactory;
import com.mastfrog.acteur.server.UnknownNetworkEventHandler;
import com.mastfrog.acteur.server.WebSocketEvent;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.codec.Codec;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.AsciiString;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.inject.Inject;

@ChannelHandler.Sharable
@Singleton
final class UpstreamHandlerImpl
extends ChannelInboundHandlerAdapter {
    private final ApplicationControl application;
    private final PathFactory paths;
    private final boolean neverKeepAlive;
    private final boolean aggregateChunks;
    private final Codec mapper;
    @Inject
    private UnknownNetworkEventHandler uneh;
    private final boolean decodeRealIP;
    private final ContentConverter converter;
    private final boolean ssl;
    private static final AsciiString X_REAL_IP = new AsciiString((CharSequence)"X-Real-IP");
    private static final AsciiString X_FORWARDED_FOR = new AsciiString((CharSequence)"X-Forwarded-For");
    private static final AsciiString FORWARDED = new AsciiString((CharSequence)"Forwarded");

    @Inject
    UpstreamHandlerImpl(ApplicationControl application, PathFactory paths, Codec mapper, Settings settings, ContentConverter converter) {
        this.application = application;
        this.paths = paths;
        this.mapper = mapper;
        this.converter = converter;
        this.aggregateChunks = settings.getBoolean("aggregateChunks", true);
        this.neverKeepAlive = settings.getBoolean("neverKeepAlive", false);
        this.decodeRealIP = settings.getBoolean("decodeRealIP", true);
        this.ssl = settings.getBoolean("ssl.enabled", false);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.application.internalOnError(cause);
    }

    public void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest request, boolean early) {
        SocketAddress addr = ctx.channel().remoteAddress();
        if (this.decodeRealIP) {
            String hdr = request.headers().get((CharSequence)X_REAL_IP);
            if (hdr == null) {
                hdr = request.headers().get((CharSequence)X_FORWARDED_FOR);
            }
            if (hdr == null) {
                hdr = request.headers().get((CharSequence)FORWARDED);
            }
            if (hdr != null) {
                addr = InetSocketAddress.createUnresolved(hdr, addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getPort() : 80);
            }
        }
        EventImpl evt = new EventImpl(request, addr, ctx, this.paths, this.converter, this.ssl);
        if (early) {
            evt.early();
        }
        evt.setNeverKeepAlive(this.neverKeepAlive);
        this.application.onEvent(evt, ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (!this.aggregateChunks && HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                UpstreamHandlerImpl.send100Continue(ctx);
            }
            this.handleHttpRequest(ctx, request, false);
        } else if (msg instanceof CloseWebSocketFrame) {
            ctx.channel().close();
        } else if (msg instanceof PingWebSocketFrame) {
            PingWebSocketFrame frame = (PingWebSocketFrame)msg;
            ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            SocketAddress addr = ctx.channel().remoteAddress();
            WebSocketEvent wsEvent = new WebSocketEvent(frame, ctx, addr, this.mapper);
            this.application.onEvent(wsEvent, ctx.channel());
        } else if (this.uneh != null) {
            this.uneh.channelRead(ctx, msg);
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }
}

