/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.server;

import com.mastfrog.acteur.Event;
import com.mastfrog.util.codec.Codec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;

public final class WebSocketEvent
implements Event<WebSocketFrame> {
    private final WebSocketFrame frame;
    private final ChannelHandlerContext channel;
    private final SocketAddress addr;
    private final Codec mapper;

    public WebSocketEvent(WebSocketFrame frame, ChannelHandlerContext channel, SocketAddress addr, Codec mapper) {
        this.frame = frame;
        this.channel = channel;
        this.addr = addr;
        this.mapper = mapper;
    }

    @Override
    public Channel channel() {
        return this.channel.channel();
    }

    @Override
    public ChannelHandlerContext ctx() {
        return this.channel;
    }

    @Override
    public WebSocketFrame request() {
        return this.frame;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.addr;
    }

    @Override
    public <T> T jsonContent(Class<T> type) throws IOException {
        return (T)this.mapper.readValue((InputStream)new ByteBufInputStream(this.frame.content()), type);
    }

    @Override
    public ByteBuf content() throws IOException {
        return this.frame.content();
    }
}

