/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.websocket;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.server.PathFactory;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.acteur.websocket.OnWebsocketConnect;
import com.mastfrog.acteurbase.Chain;
import com.mastfrog.acteurbase.Deferral;
import com.mastfrog.settings.Settings;
import com.mastfrog.url.Path;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.Protocols;
import com.mastfrog.url.URL;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;

public class WebSocketUpgradeActeur
extends Acteur {
    public static final String SETTINGS_KEY_WEBSOCKET_SECURE_PROTOCOL = "websocket.secure.urls";
    public static final boolean DEFAULT_WEBSOCKET_SECURE_PROTOCOL = false;
    public static final String SETTINGS_KEY_WEBSOCKET_FRAME_MAX_LENGTH = "websocket.frame.max.bytes";
    public static final int DEFAULT_WEBSOCKET_FRAME_MAX_LENGTH = 0x500000;
    public static final AttributeKey<Supplier<? extends Chain<? extends Acteur, ?>>> CHAIN_KEY = AttributeKey.valueOf(WebSocketUpgradeActeur.class, (String)"websocket");
    public static final AttributeKey<Page> PAGE_KEY = AttributeKey.valueOf(WebSocketUpgradeActeur.class, (String)"page");

    @Inject
    protected WebSocketUpgradeActeur(HttpEvent evt, PathFactory paths, Settings settings, Page page, Deferral defer, Chain chain, ApplicationControl ctrl, OnWebsocketConnect onConnect) {
        Path pth = paths.toExternalPath(evt.path());
        int max = settings.getInt(SETTINGS_KEY_WEBSOCKET_FRAME_MAX_LENGTH, 0x500000);
        boolean secure = settings.getBoolean(SETTINGS_KEY_WEBSOCKET_SECURE_PROTOCOL, false);
        URL url = paths.constructURL((Protocol)(secure ? Protocols.WSS : Protocols.WS), pth);
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(url.toString(), null, true, max);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)evt.request());
        if (handshaker == null) {
            this.add(Headers.stringHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION), WebSocketVersion.V13.toHttpHeaderValue());
            this.reply(HttpResponseStatus.UPGRADE_REQUIRED);
        } else {
            ChannelFuture future = handshaker.handshake(evt.channel(), (HttpRequest)evt.request());
            future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
                if (future1.isSuccess()) {
                    Channel ch = future1.channel();
                    Object a = onConnect.connected(evt, ch);
                    Object b = this.connected(evt, ch);
                    ch.attr(CHAIN_KEY).set((Object)chain.remnantSupplier(WebSocketUpgradeActeur.flatten(a, b)));
                    ch.attr(PAGE_KEY).set((Object)page);
                    return;
                }
                if (future1.cause() != null) {
                    ctrl.internalOnError(future1.cause());
                }
                future1.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }));
            Deferral.Resumer res = defer.defer();
            this.next(new Object[0]);
        }
    }

    private static Object[] flatten(Object a, Object b) {
        LinkedList result = new LinkedList();
        WebSocketUpgradeActeur.populate(a, result);
        WebSocketUpgradeActeur.populate(b, result);
        return result.toArray(new Object[0]);
    }

    private static void populate(Object o, List<? super Object> into) {
        if (o == null) {
            return;
        }
        if (o instanceof Object[]) {
            Object[] o1;
            for (Object o2 : o1 = (Object[])o) {
                WebSocketUpgradeActeur.populate(o2, into);
            }
        } else {
            into.add(o);
        }
    }

    Object connected(HttpEvent evt, Channel channel) {
        return null;
    }
}

