/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import com.mastfrog.concurrent.IntegerPair;
import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.function.state.Lng;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.IntUnaryOperator;

final class AtomicIntegerPair
implements IntegerPair {
    private volatile long value;
    private static final AtomicLongFieldUpdater<AtomicIntegerPair> UPD = AtomicLongFieldUpdater.newUpdater(AtomicIntegerPair.class, "value");

    AtomicIntegerPair() {
    }

    AtomicIntegerPair(int a, int b) {
        this.value = AtomicIntegerPair.pack(a, b);
    }

    AtomicIntegerPair(long value) {
        this.value = value;
    }

    @Override
    public long toLong() {
        return this.value();
    }

    private long value() {
        return UPD.get(this);
    }

    @Override
    public void fetch(IntBiConsumer pair) {
        long val = this.value();
        pair.accept(AtomicIntegerPair.unpackLeft(val), AtomicIntegerPair.unpackRight(val));
    }

    public int[] get() {
        int[] result = new int[2];
        this.fetch((a, b) -> {
            result[0] = a;
            result[1] = b;
        });
        return result;
    }

    @Override
    public void update(IntUnaryOperator leftFunction, IntUnaryOperator rightFunction) {
        UPD.updateAndGet(this, old -> {
            int left = leftFunction.applyAsInt(AtomicIntegerPair.unpackLeft(old));
            int right = rightFunction.applyAsInt(AtomicIntegerPair.unpackRight(old));
            return AtomicIntegerPair.pack(left, right);
        });
    }

    @Override
    public void update(IntegerPair.IntegerPairUpdater updater) {
        Lng val = Lng.create();
        UPD.updateAndGet(this, old -> {
            val.set(old);
            updater.update(AtomicIntegerPair.unpackLeft(old), AtomicIntegerPair.unpackRight(old), (newLeft, newRight) -> val.set(AtomicIntegerPair.pack(newLeft, newRight)));
            return val.getAsLong();
        });
    }

    @Override
    public boolean compareAndSet(int expectedLeftValue, int expectedRightValue, int newLeftValue, int newRightValue) {
        long expect = AtomicIntegerPair.pack(expectedLeftValue, expectedRightValue);
        long nue = AtomicIntegerPair.pack(newLeftValue, newRightValue);
        return UPD.compareAndSet(this, expect, nue);
    }

    public void swap() {
        UPD.updateAndGet(this, old -> {
            int left = AtomicIntegerPair.unpackLeft(old);
            int right = AtomicIntegerPair.unpackRight(old);
            return AtomicIntegerPair.pack(right, left);
        });
    }

    @Override
    public void set(int left, int right) {
        UPD.set(this, AtomicIntegerPair.pack(left, right));
    }

    @Override
    public void setLeft(int newLeft) {
        UPD.updateAndGet(this, old -> {
            int left = newLeft;
            int right = AtomicIntegerPair.unpackRight(old);
            return AtomicIntegerPair.pack(left, right);
        });
    }

    @Override
    public void setRight(int newRight) {
        UPD.updateAndGet(this, old -> {
            int left = AtomicIntegerPair.unpackLeft(old);
            int right = newRight;
            return AtomicIntegerPair.pack(left, right);
        });
    }

    @Override
    public int left() {
        long val = this.value();
        return (int)(val >> 32);
    }

    @Override
    public int right() {
        return AtomicIntegerPair.unpackRight(this.value());
    }

    static long pack(int left, int right) {
        return (long)left << 32 | (long)right & 0xFFFFFFFFL;
    }

    static int unpackLeft(long value) {
        return (int)(value >>> 32 & 0xFFFFFFFFL);
    }

    static int unpackRight(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        this.fetch((a, b) -> sb.append(a).append(", ").append(b));
        return sb.append(')').toString();
    }
}

