/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import com.mastfrog.function.IntQuadConsumer;
import com.mastfrog.function.IntQuadFunction;
import com.mastfrog.function.state.Lng;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class AtomicSmallInts
implements Serializable {
    private static final AtomicLongFieldUpdater<AtomicSmallInts> UPD = AtomicLongFieldUpdater.newUpdater(AtomicSmallInts.class, "value");
    private volatile long value;

    public AtomicSmallInts() {
    }

    public AtomicSmallInts(int a, int b, int c, int d) {
        this.value = AtomicSmallInts.pack(a, b, c, d);
    }

    public int[] toArray() {
        int[] result = new int[4];
        this.get((a, b, c, d) -> {
            result[0] = a;
            result[1] = b;
            result[2] = c;
            result[3] = d;
        });
        return result;
    }

    public AtomicSmallInts get(IntQuadConsumer quad) {
        long val = UPD.get(this);
        quad.accept(AtomicSmallInts.unpackA(val), AtomicSmallInts.unpackB(val), AtomicSmallInts.unpackC(val), AtomicSmallInts.unpackD(val));
        return this;
    }

    public <T> T get(IntQuadFunction<T> func) {
        long val = this.longValue();
        return (T)func.apply(AtomicSmallInts.unpackA(val), AtomicSmallInts.unpackB(val), AtomicSmallInts.unpackC(val), AtomicSmallInts.unpackD(val));
    }

    public long longValue() {
        return UPD.get(this);
    }

    public AtomicSmallInts set(int a, int b, int c, int d) {
        UPD.set(this, AtomicSmallInts.pack(a, b, c, d));
        return this;
    }

    public int a() {
        return AtomicSmallInts.unpackA(this.longValue());
    }

    public int b() {
        return AtomicSmallInts.unpackB(this.longValue());
    }

    public int c() {
        return AtomicSmallInts.unpackC(this.longValue());
    }

    public int d() {
        return AtomicSmallInts.unpackD(this.longValue());
    }

    public AtomicSmallInts setA(int a) {
        this.update((oa, b, c, d, con) -> con.accept(a, b, c, d));
        return this;
    }

    public AtomicSmallInts setB(int b) {
        this.update((a, ob, c, d, con) -> con.accept(a, b, c, d));
        return this;
    }

    public AtomicSmallInts setC(int c) {
        this.update((a, b, oc, d, con) -> con.accept(a, b, c, d));
        return this;
    }

    public AtomicSmallInts setD(int d) {
        this.update((a, b, c, od, con) -> con.accept(a, b, c, d));
        return this;
    }

    public AtomicSmallInts update(ASIUpdater upd) {
        UPD.getAndUpdate(this, old -> {
            Lng lng = Lng.of((long)old);
            upd.update(AtomicSmallInts.unpackA(old), AtomicSmallInts.unpackB(old), AtomicSmallInts.unpackC(old), AtomicSmallInts.unpackD(old), (a, b, c, d) -> lng.set(AtomicSmallInts.pack(a, b, c, d)));
            return lng.getAsLong();
        });
        return this;
    }

    public int[] get() {
        int[] result = new int[4];
        this.get((a, b, c, d) -> {
            result[0] = a;
            result[1] = b;
            result[2] = c;
            result[3] = d;
        });
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        this.get((a, b, c, d) -> sb.append(a).append(", ").append(b).append(", ").append(c).append(", ").append(d));
        return sb.append(")").toString();
    }

    static int rangeCheck(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("Value out of range 0-65535: " + val);
        }
        return val;
    }

    static long pack(int a, int b, int c, int d) {
        return AtomicSmallInts.checkRange(a) << 48 | (AtomicSmallInts.checkRange(b) & 0xFFFFFFFFFFFFL) << 32 | (AtomicSmallInts.checkRange(c) & 0xFFFFFFFFFFFFL) << 16 | AtomicSmallInts.checkRange(d) & 0xFFFFFFFFFFFFL;
    }

    static int unpackA(long value) {
        return (int)(value >>> 48 & 0xFFFFL);
    }

    static int unpackB(long value) {
        return (int)(value >>> 32 & 0xFFFFL);
    }

    static int unpackC(long value) {
        return (int)(value >>> 16 & 0xFFFFL);
    }

    static int unpackD(long value) {
        return (int)(value & 0xFFFFL);
    }

    static long checkRange(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("Out of range 0-65535");
        }
        return val;
    }

    public static interface ASIUpdater {
        public void update(int var1, int var2, int var3, int var4, IntQuadConsumer var5);
    }
}

