/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class ConcurrentLinkedList<T>
implements Iterable<T> {
    private static final AtomicReferenceFieldUpdater<ConcurrentLinkedList, Cell> HEAD = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedList.class, Cell.class, "head");
    private volatile Cell<T> head;
    private final boolean fifo;

    public static <T> ConcurrentLinkedList<T> lifo() {
        return new ConcurrentLinkedList<T>(false, null);
    }

    public static <T> ConcurrentLinkedList<T> fifo() {
        return new ConcurrentLinkedList<T>(true, null);
    }

    ConcurrentLinkedList(boolean fifo, Cell<T> head) {
        this.fifo = fifo;
        this.head = head;
    }

    public boolean isEmpty() {
        return this.headCell() == null;
    }

    public int size() {
        Cell<T> headCell = this.headCell();
        return headCell == null ? 0 : headCell.size();
    }

    public ConcurrentLinkedList<T> copy() {
        Cell<T> headCell = this.headCell();
        return new ConcurrentLinkedList<T>(this.fifo, headCell == null ? null : headCell.copy());
    }

    public boolean isFifo() {
        return this.fifo;
    }

    public boolean contains(Object o) {
        boolean result = false;
        for (Cell<T> cell = this.headCell(); cell != null; cell = cell.next()) {
            if (!Objects.equals(o, cell.get())) continue;
            return true;
        }
        return result;
    }

    public ConcurrentLinkedList<T> push(T obj) {
        HEAD.getAndUpdate(this, cell -> {
            if (cell == null) {
                return new Cell<Object>(obj);
            }
            if (!this.fifo) {
                return new Cell<Object>(obj, (Cell<Object>)cell);
            }
            cell.append(obj);
            return cell;
        });
        return this;
    }

    Cell<T> headCell() {
        return HEAD.get(this);
    }

    public T peek() {
        Cell<T> h = this.headCell();
        return h == null ? null : (T)h.get();
    }

    public T pop() {
        Cell old = HEAD.getAndUpdate(this, cell -> cell == null ? null : cell.next());
        return old == null ? null : (T)old.get();
    }

    @Override
    public void forEach(Consumer<? super T> c) {
        Cell<T> headCell = this.headCell();
        if (headCell == null) {
            return;
        }
        headCell.each(cell -> c.accept((Object)cell.get()));
    }

    public int drain(Consumer<T> c) {
        Cell old = HEAD.getAndUpdate(this, cell -> null);
        if (old != null) {
            return old.each(cell -> c.accept(cell.get()));
        }
        return 0;
    }

    public int drain(T newHead, Consumer<T> c) {
        Cell old = HEAD.getAndUpdate(this, cell -> new Cell<Object>(newHead));
        if (old != null) {
            return old.each(cell -> c.accept(cell.get()));
        }
        return 0;
    }

    @Override
    public Iterator<T> iterator() {
        Cell<T> h = this.headCell();
        return h == null ? Collections.emptyIterator() : h.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (Cell<T> cell = this.headCell(); cell != null; cell = cell.next()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(cell.get());
        }
        return sb.append(']').toString();
    }

    private static class Cell<T>
    implements Supplier<T>,
    Iterable<T> {
        private static final AtomicReferenceFieldUpdater<Cell, Cell> NEXT = AtomicReferenceFieldUpdater.newUpdater(Cell.class, Cell.class, "next");
        private volatile Cell<T> next;
        private final T value;

        Cell(T value) {
            this.value = value;
        }

        Cell(T value, Cell<T> next) {
            this.value = value;
            this.next = next;
        }

        Cell<T> clearNext() {
            return NEXT.getAndSet(this, null);
        }

        public String toString() {
            return Objects.toString(this.value);
        }

        Cell<T> copy() {
            Cell<T> n = this.next();
            return new Cell<T>(this.value, n == null ? null : n.copy());
        }

        @Override
        public T get() {
            return this.value;
        }

        public int size() {
            int result = 0;
            for (Cell<T> cell = this; cell != null; cell = cell.next()) {
                ++result;
            }
            return result;
        }

        int each(Consumer<? super Cell<T>> cellConsumer) {
            cellConsumer.accept(this);
            int result = 1;
            Cell<T> nextCell = this.next();
            while (nextCell != null) {
                cellConsumer.accept(nextCell);
                nextCell = nextCell.next();
                ++result;
            }
            return result;
        }

        @Override
        public void forEach(Consumer<? super T> cellConsumer) {
            this.each(cell -> cellConsumer.accept((Object)cell.get()));
        }

        private Cell<T> doUpdate(UnaryOperator<Cell<T>> uo) {
            UnaryOperator<Cell<T>> cast = uo;
            return NEXT.getAndUpdate(this, cast);
        }

        Cell<T> next() {
            return NEXT.get(this);
        }

        Cell<T> updateLast(UnaryOperator<Cell<T>> u) {
            U<T> uu = new U<T>(u);
            Cell<T> cell = this;
            while (true) {
                if (cell.next == null) {
                    cell.doUpdate(uu);
                    return uu.last;
                }
                cell = cell.next();
            }
        }

        protected void append(T obj) {
            Cell updated;
            Cell nue = new Cell(obj);
            Cell<T> cell = this;
            while (cell != null && (updated = NEXT.updateAndGet(cell, old -> {
                if (old == null) {
                    return nue;
                }
                return old;
            })) != nue) {
                cell = cell.next;
            }
        }

        @Override
        public Iterator<T> iterator() {
            return new Iter(this);
        }

        static class Iter<T>
        implements Iterator<T> {
            Cell<T> current;

            Iter(Cell<T> first) {
                this.current = first;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public T next() {
                Cell<T> old = this.current;
                if (old == null) {
                    throw new NoSuchElementException();
                }
                this.current = old.next();
                return old.get();
            }
        }

        static class U<T>
        implements UnaryOperator<Cell<T>> {
            private final UnaryOperator<Cell<T>> real;
            Cell<T> last;

            public U(UnaryOperator<Cell<T>> real) {
                this.real = real;
            }

            Cell<T> perform(Cell<T> initial) {
                assert (initial != null);
                this.last = initial;
                return ((Cell)initial).doUpdate(this);
            }

            @Override
            public Cell<T> apply(Cell<T> old) {
                if (old == null) {
                    return (Cell)this.real.apply(this.last);
                }
                return this.perform(old);
            }
        }
    }
}

