/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import com.mastfrog.util.preconditions.Checks;
import java.time.Duration;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.function.Supplier;

public final class IncrementableLatch {
    private final Sync sync = new Sync();

    IncrementableLatch() {
    }

    int count() {
        return this.sync.count();
    }

    public static IncrementableLatch create() {
        return new IncrementableLatch();
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean increment() {
        return this.sync.increment();
    }

    public void hold(Runnable r) {
        this.increment();
        try {
            ((Runnable)Checks.notNull((String)"r", (Object)r)).run();
        }
        finally {
            this.countDown();
        }
    }

    public <T> T hold(Supplier<T> supp) {
        this.increment();
        try {
            Object t = ((Supplier)Checks.notNull((String)"supp", supp)).get();
            return t;
        }
        finally {
            this.countDown();
        }
    }

    public boolean await(Duration duration) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, Long.max(0L, duration.toNanos()));
    }

    public boolean isUnused() {
        return this.sync.isPristine();
    }

    public boolean countDown() {
        return this.sync.releaseShared(1);
    }

    public void releaseAll() {
        this.sync.clear();
    }

    public boolean hasWaiters() {
        return this.sync.hasQueuedThreads();
    }

    public String toString() {
        return Integer.toString(this.sync.count());
    }

    static int masked(int val) {
        return val & Integer.MAX_VALUE;
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        Sync() {
            this.setState(Integer.MIN_VALUE);
        }

        int count() {
            int st = this.getState();
            int result = IncrementableLatch.masked(st);
            if (result != st) {
                return 1;
            }
            return result;
        }

        int clear() {
            int old;
            do {
                old = this.getState();
                boolean nue = false;
            } while (!this.compareAndSetState(old, 0));
            return IncrementableLatch.masked(old);
        }

        boolean isPristine() {
            int st = this.getState();
            int result = IncrementableLatch.masked(st);
            return result != st;
        }

        boolean increment() {
            int nextC;
            int c;
            while (!this.compareAndSetState(c = this.getState(), nextC = IncrementableLatch.masked(c) + 1)) {
            }
            return c == 0;
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                int m;
                if ((m = IncrementableLatch.masked(c = this.getState())) != 0 && m == c) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = IncrementableLatch.masked(c) - 1));
            return nextc == 0;
        }
    }
}

