/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;

public class Periodic
implements BooleanSupplier {
    private static final long MASK = Long.MIN_VALUE;
    private final long interval;
    private AtomicLong lastUpdated = new AtomicLong();

    public Periodic(long millis) {
        this.interval = millis;
    }

    public Periodic(Duration dur) {
        this(dur.toMillis());
    }

    @Override
    public boolean getAsBoolean() {
        long now = System.currentTimeMillis();
        long nue = this.lastUpdated.updateAndGet(old -> {
            long masked = Periodic.maskedTimstamp(old);
            if (Periodic.hasBit(old)) {
                return masked;
            }
            if (now - masked > this.interval) {
                return Periodic.withBit(now);
            }
            return old;
        });
        return Periodic.hasBit(nue);
    }

    private static boolean hasBit(long val) {
        return (val & Long.MIN_VALUE) != 0L;
    }

    private static long maskedTimstamp(long val) {
        return val & Long.MAX_VALUE;
    }

    private static long withBit(long val) {
        return val | Long.MIN_VALUE;
    }
}

