/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.coalesce;

import com.mastfrog.concurrent.coalesce.WorkCoalescer;
import com.mastfrog.function.throwing.ThrowingSupplier;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Coalescer<T>
implements ThrowingSupplier<T> {
    private final WorkCoalescer<T> wc;
    private final AtomicReference<T> ref = new AtomicReference();
    private final Predicate<T> expiredTest;
    private final Supplier<T> valueSupplier;

    public Coalescer(Predicate<T> expiredTest, Supplier<T> valueSupplier) {
        this("unnamed", expiredTest, valueSupplier);
    }

    public Coalescer(Supplier<T> valueSupplier) {
        this("unnamed", valueSupplier);
    }

    public Coalescer(String name, Supplier<T> valueSupplier) {
        this(name, old -> false, valueSupplier);
    }

    public Coalescer(String name, Predicate<T> expiredTest, Supplier<T> valueSupplier) {
        this.wc = new WorkCoalescer(name);
        this.expiredTest = expiredTest;
        this.valueSupplier = valueSupplier;
    }

    public T current() {
        return this.ref.get();
    }

    public T get() throws InterruptedException {
        return (T)this.wc.coalesceComputation(() -> {
            T old = this.ref.get();
            if (old != null && !this.expiredTest.test(old)) {
                return old;
            }
            return this.valueSupplier.get();
        }, this.ref);
    }
}

