/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.coalesce;

import com.mastfrog.concurrent.ConcurrentLinkedList;
import com.mastfrog.function.BooleanFunction;
import com.mastfrog.function.state.Int;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;

public final class WorkCoalescer<T> {
    private final ConcurrentLinkedList<AtomicReference<T>> stack = ConcurrentLinkedList.lifo();
    private final Sync sync = new Sync();
    private final String name;

    public WorkCoalescer(String name) {
        this.name = name;
    }

    public WorkCoalescer() {
        this("unnamed");
    }

    private void drainAndApply(T val) {
        AtomicReference<T> last = null;
        while (!this.stack.isEmpty()) {
            AtomicReference<T> ref = this.stack.pop();
            if (ref != null && ref != last) {
                ref.set(val);
            }
            last = ref;
        }
    }

    public T coalesceComputation(Supplier<T> resultComputation, AtomicReference<T> ref) throws InterruptedException {
        this.stack.push(ref);
        return this.sync.hold(first -> {
            Object result;
            if (first) {
                result = resultComputation.get();
                this.drainAndApply(result);
            } else {
                result = ref.get();
            }
            return result;
        });
    }

    public String toString() {
        return this.name + "(" + this.sync + ")";
    }

    private static final class Sync {
        private final AtomicBoolean state = new AtomicBoolean();
        private final ConcurrentLinkedList<Thread> threads = ConcurrentLinkedList.fifo();

        private Sync() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Int count = Int.create();
            this.threads.forEach(thread -> {
                if (count.increment() > 0) {
                    sb.append(",");
                }
                sb.append(thread.getName());
            });
            String msg = this.state.get() ? "locked" : (count.getAsInt() > 0 ? "draining" : "unlocked");
            return msg + " with " + count + " threads: " + sb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T hold(BooleanFunction<T> c) {
            boolean first = this.state.compareAndSet(false, true);
            if (!first) {
                this.threads.push(Thread.currentThread());
                LockSupport.park(this);
            }
            Object result = c.applyAsBoolean(first);
            if (first) {
                try {
                    while (!this.threads.isEmpty()) {
                        Thread t = this.threads.pop();
                        if (t == null) continue;
                        LockSupport.unpark(t);
                    }
                }
                finally {
                    this.state.set(false);
                }
            }
            return (T)result;
        }
    }
}

