/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.future;

import com.mastfrog.util.preconditions.Exceptions;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface Awaitable<T> {
    public T await() throws InterruptedException;

    public T await(long var1, TimeUnit var3) throws InterruptedException;

    default public T await(Duration duration) throws InterruptedException {
        return this.await(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    default public T awaitQuietly(Duration duration) {
        try {
            return this.await(duration);
        }
        catch (InterruptedException ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
    }

    default public T awaitQuietly() {
        try {
            return this.await();
        }
        catch (InterruptedException ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
    }

    public static <T> Awaitable<T> wrap(final Future<T> fut) {
        return new Awaitable<T>(){

            @Override
            public T await() throws InterruptedException {
                try {
                    return fut.get();
                }
                catch (ExecutionException ex) {
                    return Exceptions.chuck((Throwable)(ex.getCause() == null ? ex : ex.getCause()));
                }
            }

            @Override
            public T await(long amount, TimeUnit unit) throws InterruptedException {
                try {
                    return fut.get(amount, unit);
                }
                catch (ExecutionException ex) {
                    return Exceptions.chuck((Throwable)(ex.getCause() == null ? ex : ex.getCause()));
                }
                catch (TimeoutException ex) {
                    return Exceptions.chuck((Throwable)(ex.getCause() == null ? ex : ex.getCause()));
                }
            }
        };
    }
}

