/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.lock;

import com.mastfrog.concurrent.lock.Favor;
import com.mastfrog.concurrent.lock.SlottedLock;
import com.mastfrog.function.throwing.ThrowingRunnable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import java.util.concurrent.locks.LockSupport;
import java.util.function.IntPredicate;

final class MultiLock
implements SlottedLock {
    private final Sync sync = new Sync();
    private final ThreadLocal<Long> tl = ThreadLocal.withInitial(() -> 0L);

    MultiLock() {
    }

    @Override
    public void lock(int index) throws InterruptedException {
        this.lockBits(1L << this.validate64(index));
    }

    @Override
    public boolean unlock(int index) {
        return this.unlockBits(1L << this.validate64(index));
    }

    @Override
    public void lock(int first, int ... more) throws InterruptedException {
        this.lockBits(this.toBits(first, more));
    }

    @Override
    public void lock(BitSet slots) throws InterruptedException {
        this.lockBits(this.toBits(slots));
    }

    @Override
    public boolean unlock(int first, int ... more) {
        return this.unlockBits(this.toBits(first, more));
    }

    @Override
    public boolean unlock(BitSet slots) {
        return this.unlockBits(this.toBits(slots));
    }

    @Override
    public PrimitiveIterator.OfInt acquireN(int n) {
        return this.acquireN(n, Favor.BOTH);
    }

    @Override
    public PrimitiveIterator.OfInt acquireN(int n, Favor favoring) {
        if (n <= 0 || n > 64) {
            throw new IllegalArgumentException("N must be between 1 and 64: " + n);
        }
        long result = this.sync.acquire(n, favoring);
        return new BitsIter(result);
    }

    @Override
    public PrimitiveIterator.OfInt acquireN(int n, Favor favoring, IntPredicate excluder) {
        if (n <= 0 || n > 64) {
            throw new IllegalArgumentException("N must be between 1 and 64: " + n);
        }
        long result = this.sync.acquire(n, favoring, excluder);
        return new BitsIter(result);
    }

    @Override
    public boolean isLocked(int first, int ... more) {
        return this.sync.anyLocked(this.toBits(first, more));
    }

    @Override
    public boolean isLocked(BitSet slots) {
        if (slots.isEmpty()) {
            return false;
        }
        return this.sync.anyLocked(this.toBits(slots));
    }

    @Override
    public boolean isLocked(int ix) {
        return this.sync.anyLocked(1L << this.validate64(ix));
    }

    @Override
    public boolean isLocked() {
        return this.sync.state() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockingThrowing(ThrowingRunnable run, int first, int ... more) throws Exception {
        this.lock(first, more);
        try {
            run.run();
        }
        finally {
            this.unlock(first, more);
        }
    }

    @Override
    public void lockingThrowing(ThrowingRunnable run, BitSet slots) throws Exception {
        if (slots.isEmpty()) {
            run.run();
            return;
        }
        this.lock(slots);
        try {
            run.run();
        }
        finally {
            this.unlock(slots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockingReentrantlyThrowing(ThrowingRunnable run, int first, int ... more) throws Exception {
        long val = this.tl.get();
        long nue = this.toBits(first, more);
        long masked = nue & (val ^ 0xFFFFFFFFFFFFFFFFL);
        try {
            this.tl.set(nue);
            this.lockBits(masked);
            run.run();
        }
        finally {
            this.unlockBits(masked);
            this.tl.set(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockingReentrantlyThrowing(ThrowingRunnable run, BitSet bits) throws Exception {
        long val = this.tl.get();
        long nue = this.toBits(bits);
        long masked = nue & (val ^ 0xFFFFFFFFFFFFFFFFL);
        try {
            this.tl.set(nue);
            this.lockBits(masked);
            run.run();
        }
        finally {
            this.unlockBits(masked);
            this.tl.set(val);
        }
    }

    @Override
    public int available() {
        return this.sync.available();
    }

    @Override
    public int inUse() {
        return this.sync.inUse();
    }

    private long toBits(int first, int ... more) {
        long result = 1L << this.validate64(first);
        for (int i = 0; i < more.length; ++i) {
            result |= 1L << this.validate64(more[i]);
        }
        return result;
    }

    private long toBits(BitSet bits) {
        long result = 0L;
        int bit = bits.nextSetBit(0);
        while (bit >= 0) {
            this.validate64(bit);
            result |= 1L << bit;
            bit = bits.nextSetBit(bit + 1);
        }
        return result;
    }

    private int validate64(int val) {
        if (val < 0 || val >= 64) {
            throw new IllegalArgumentException("Out of range 0-63 inclusive: " + val);
        }
        return val;
    }

    private void lockBits(long toLock) throws InterruptedException {
        this.sync.acquireSharedInterruptibly(toLock);
    }

    private boolean unlockBits(long toUnlock) {
        return this.sync.releaseShared(toUnlock);
    }

    long state() {
        return this.sync.state();
    }

    public String toString() {
        return this.sync.toString();
    }

    @Override
    public int terminate() {
        int result = this.sync.terminate();
        return result;
    }

    static String toString(long st) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            long mask = 1L << i;
            if ((st & mask) == 0L) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(i);
        }
        if (sb.length() == 0) {
            sb.append("-empty-");
        }
        return sb.toString();
    }

    private static class BitsIter
    implements PrimitiveIterator.OfInt {
        private long value;

        BitsIter(long value) {
            this.value = value;
        }

        public String toString() {
            return MultiLock.toString(this.value);
        }

        @Override
        public int nextInt() {
            if (this.value == 0L) {
                throw new NoSuchElementException();
            }
            long val = Long.lowestOneBit(this.value);
            this.value &= val ^ 0xFFFFFFFFFFFFFFFFL;
            return Long.numberOfTrailingZeros(val);
        }

        @Override
        public boolean hasNext() {
            return this.value != 0L;
        }
    }

    private static class Sync
    extends AbstractQueuedLongSynchronizer {
        private Sync() {
        }

        @Override
        public String toString() {
            return MultiLock.toString(this.getState());
        }

        int terminate() {
            int ct = 0;
            HashSet<Thread> seen = new HashSet<Thread>();
            for (Thread t : super.getQueuedThreads()) {
                if (LockSupport.getBlocker(t) != this) continue;
                seen.add(t);
                t.interrupt();
                ++ct;
            }
            this.setState(-1L);
            for (Thread t : super.getQueuedThreads()) {
                if (seen.contains(t) || LockSupport.getBlocker(t) != this) continue;
                t.interrupt();
                ++ct;
            }
            return ct;
        }

        long state() {
            return this.getState();
        }

        int inUse() {
            return Long.bitCount(this.getState());
        }

        int available() {
            return 64 - this.inUse();
        }

        boolean anyLocked(long val) {
            return (val & this.getState()) != 0L;
        }

        long acquire(int n, Favor favor) {
            long state = this.getState();
            long compl = state ^ 0xFFFFFFFFFFFFFFFFL;
            long availBits = Long.bitCount(compl);
            if (availBits < (long)n) {
                return 0L;
            }
            while (availBits >= (long)n) {
                boolean enough;
                long temp = compl;
                long test = 0L;
                long leastZeroBit = favor.favor(temp, 0);
                test |= leastZeroBit;
                for (int i = 1; i < n; ++i) {
                    leastZeroBit = favor.favor(temp &= leastZeroBit ^ 0xFFFFFFFFFFFFFFFFL, i);
                    test |= leastZeroBit;
                }
                boolean bl = enough = Long.bitCount(test) == n;
                if (enough && this.compareAndSetState(state, state | test)) {
                    return test;
                }
                if (enough) {
                    state = this.getState();
                    compl = state ^ 0xFFFFFFFFFFFFFFFFL;
                    availBits = Long.bitCount(compl);
                    continue;
                }
                --availBits;
                compl &= leastZeroBit ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return 0L;
        }

        int firstSetBit(long val) {
            int result = Long.numberOfTrailingZeros(val);
            if (result == 64) {
                return -1;
            }
            return result;
        }

        long acquire(int n, Favor favor, IntPredicate tester) {
            long state = this.getState();
            long compl = state ^ 0xFFFFFFFFFFFFFFFFL;
            long availBits = Long.bitCount(compl);
            if (availBits < (long)n) {
                return 0L;
            }
            while (availBits >= (long)n) {
                boolean enough;
                long temp = compl;
                long provisionalResult = 0L;
                long leastZeroBit = favor.favor(temp, 0);
                while (!tester.test(this.firstSetBit(leastZeroBit))) {
                    temp = compl &= leastZeroBit ^ 0xFFFFFFFFFFFFFFFFL;
                    --availBits;
                    if (Long.bitCount(compl) < n) {
                        return 0L;
                    }
                    leastZeroBit = favor.favor(temp, 0);
                }
                provisionalResult |= leastZeroBit;
                for (int i = 1; i < n; ++i) {
                    if (!tester.test(Long.numberOfTrailingZeros(leastZeroBit = favor.favor(temp &= leastZeroBit ^ 0xFFFFFFFFFFFFFFFFL, i)))) {
                        temp &= leastZeroBit ^ 0xFFFFFFFFFFFFFFFFL;
                        leastZeroBit = 0L;
                        if (Long.bitCount(temp) + Long.bitCount(provisionalResult) < n) {
                            return 0L;
                        }
                        --i;
                        continue;
                    }
                    provisionalResult |= leastZeroBit;
                }
                boolean bl = enough = Long.bitCount(provisionalResult) == n;
                if (enough && this.compareAndSetState(state, state | provisionalResult)) {
                    return provisionalResult;
                }
                if (enough) {
                    state = this.getState();
                    compl = state ^ 0xFFFFFFFFFFFFFFFFL;
                    availBits = Long.bitCount(compl);
                    continue;
                }
                --availBits;
                compl &= leastZeroBit ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return 0L;
        }

        @Override
        protected long tryAcquireShared(long arg) {
            long old = this.getState();
            if ((old & arg) != 0L) {
                return -1L;
            }
            boolean result = this.compareAndSetState(old, old | arg);
            return result ? 0L : -1L;
        }

        @Override
        protected boolean tryReleaseShared(long arg) {
            long st;
            boolean result;
            do {
                if (((st = this.getState()) & arg) != 0L) continue;
                return false;
            } while (!(result = this.compareAndSetState(st, st & (arg ^ 0xFFFFFFFFFFFFFFFFL))));
            return result;
        }

        @Override
        protected boolean isHeldExclusively() {
            return false;
        }
    }
}

