/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.lock;

import com.mastfrog.function.state.Int;
import com.mastfrog.function.state.Lng;
import com.mastfrog.function.state.Obj;
import com.mastfrog.function.throwing.ThrowingIntSupplier;
import com.mastfrog.function.throwing.ThrowingLongSupplier;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.function.throwing.io.IOIntSupplier;
import com.mastfrog.function.throwing.io.IOLongSupplier;
import com.mastfrog.function.throwing.io.IORunnable;
import com.mastfrog.function.throwing.io.IOSupplier;
import com.mastfrog.util.preconditions.Exceptions;
import java.io.IOException;
import java.util.BitSet;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public interface MultiplyLockable {
    default public long slotCount() {
        return 64L;
    }

    public void lockingThrowing(ThrowingRunnable var1, BitSet var2) throws Exception;

    public void lockingThrowing(ThrowingRunnable var1, int var2, int ... var3) throws Exception;

    public void lockingReentrantlyThrowing(ThrowingRunnable var1, BitSet var2) throws Exception;

    public void lockingReentrantlyThrowing(ThrowingRunnable var1, int var2, int ... var3) throws Exception;

    default public void lockingReentrantlyIO(IORunnable run, BitSet bits) throws InterruptedException, IOException {
        try {
            this.lockingReentrantlyThrowing((ThrowingRunnable)run, bits);
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    default public void lockingReentrantlyIO(IORunnable run, int first, int ... more) throws IOException {
        try {
            this.lockingReentrantlyThrowing((ThrowingRunnable)run, first, more);
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    default public void lockingReentrantly(Runnable run, BitSet slots) throws InterruptedException {
        try {
            this.lockingReentrantlyThrowing(run::run, slots);
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    default public void lockingReentrantly(Runnable run, int first, int ... more) throws InterruptedException {
        try {
            this.lockingReentrantlyThrowing(run::run, first, more);
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    default public <T> T getLockingReentrantly(Supplier<T> supp, int first, int ... more) throws InterruptedException {
        Obj obj = Obj.create();
        this.lockingReentrantly(() -> obj.set(supp.get()), first, more);
        return (T)obj.get();
    }

    default public <T> T getLockingReentrantlyThrowing(ThrowingSupplier<T> supp, int first, int ... more) throws Exception {
        Obj obj = Obj.create();
        this.lockingReentrantlyThrowing(() -> obj.set(supp.get()), first, more);
        return (T)obj.get();
    }

    default public <T> T getLockingReentrantlyIO(IOSupplier<T> supp, int first, int ... more) throws InterruptedException, IOException {
        Obj obj = Obj.create();
        try {
            this.lockingReentrantlyThrowing(() -> obj.set(supp.get()), first, more);
        }
        catch (Exception ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
        return (T)obj.get();
    }

    default public <T> T getLockingReentrantly(Supplier<T> supp, BitSet slots) throws InterruptedException {
        Obj obj = Obj.create();
        this.lockingReentrantly(() -> obj.set(supp.get()), slots);
        return (T)obj.get();
    }

    default public <T> T getLockingReentrantlyThrowing(ThrowingSupplier<T> supp, BitSet slots) throws Exception {
        Obj obj = Obj.create();
        this.lockingReentrantlyThrowing(() -> obj.set(supp.get()), slots);
        return (T)obj.get();
    }

    default public <T> T getLockingReentrantlyIO(IOSupplier<T> supp, BitSet slots) throws InterruptedException, IOException {
        Obj obj = Obj.create();
        try {
            this.lockingReentrantlyThrowing(() -> obj.set(supp.get()), slots);
        }
        catch (Exception ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
        return (T)obj.get();
    }

    default public long lockingReentrantly(LongSupplier supp, int first, int ... more) throws InterruptedException {
        Lng lng = Lng.create();
        this.lockingReentrantly(() -> lng.set(supp.getAsLong()), first, more);
        return lng.get();
    }

    default public int lockingReentrantly(IntSupplier supp, int first, int ... more) throws InterruptedException {
        Int in = Int.create();
        this.lockingReentrantly(() -> in.set(supp.getAsInt()), first, more);
        return in.get();
    }

    default public long lockingReentrantlyIO(IOLongSupplier supp, int first, int ... more) throws InterruptedException, IOException {
        Lng lng = Lng.create();
        try {
            this.lockingReentrantlyThrowing(() -> lng.set(supp.getAsLong()), first, more);
        }
        catch (Exception ex) {
            return (Long)Exceptions.chuck((Throwable)ex);
        }
        return lng.get();
    }

    default public int lockingReentrantlyIO(IOIntSupplier supp, int first, int ... more) throws InterruptedException, IOException {
        Int in = Int.create();
        try {
            this.lockingReentrantlyThrowing(() -> in.set(supp.getAsInt()), first, more);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }

    default public long lockingReentrantlyThrowing(ThrowingLongSupplier supp, int first, int ... more) throws Exception {
        Lng lng = Lng.create();
        this.lockingReentrantlyThrowing(() -> lng.set(supp.getAsLong()), first, more);
        return lng.get();
    }

    default public int lockingReentrantlyThrowing(ThrowingIntSupplier supp, int first, int ... more) throws Exception {
        Int in = Int.create();
        try {
            this.lockingReentrantlyThrowing(() -> in.set(supp.getAsInt()), first, more);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }

    default public long lockingReentrantly(LongSupplier supp, BitSet slots) throws InterruptedException {
        Lng lng = Lng.create();
        this.lockingReentrantly(() -> lng.set(supp.getAsLong()), slots);
        return lng.get();
    }

    default public int lockingReentrantly(IntSupplier supp, BitSet slots) throws InterruptedException {
        Int in = Int.create();
        this.lockingReentrantly(() -> in.set(supp.getAsInt()), slots);
        return in.get();
    }

    default public long lockingReentrantlyIO(IOLongSupplier supp, BitSet slots) throws InterruptedException, IOException {
        Lng lng = Lng.create();
        try {
            this.lockingReentrantlyThrowing(() -> lng.set(supp.getAsLong()), slots);
        }
        catch (Exception ex) {
            return (Long)Exceptions.chuck((Throwable)ex);
        }
        return lng.get();
    }

    default public int lockingReentrantlyIO(IOIntSupplier supp, BitSet slots) throws InterruptedException, IOException {
        Int in = Int.create();
        try {
            this.lockingReentrantlyThrowing(() -> in.set(supp.getAsInt()), slots);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }

    default public long lockingReentrantlyThrowing(ThrowingLongSupplier supp, BitSet slots) throws Exception {
        Lng lng = Lng.create();
        this.lockingReentrantlyThrowing(() -> lng.set(supp.getAsLong()), slots);
        return lng.get();
    }

    default public int lockingReentrantlyThrowing(ThrowingIntSupplier supp, BitSet slots) throws Exception {
        Int in = Int.create();
        try {
            this.lockingReentrantlyThrowing(() -> in.set(supp.getAsInt()), slots);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }

    default public void locking(Runnable run, BitSet slots) throws InterruptedException {
        try {
            this.lockingThrowing(run::run, slots);
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    default public void locking(Runnable run, int first, int ... more) throws InterruptedException {
        try {
            this.lockingThrowing(run::run, first, more);
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    default public <T> T getLocking(Supplier<T> supp, int first, int ... more) throws InterruptedException {
        Obj obj = Obj.create();
        this.locking(() -> obj.set(supp.get()), first, more);
        return (T)obj.get();
    }

    default public <T> T getLockingThrowing(ThrowingSupplier<T> supp, int first, int ... more) throws Exception {
        Obj obj = Obj.create();
        this.lockingThrowing(() -> obj.set(supp.get()), first, more);
        return (T)obj.get();
    }

    default public <T> T getLockingIO(IOSupplier<T> supp, int first, int ... more) throws InterruptedException, IOException {
        Obj obj = Obj.create();
        try {
            this.lockingThrowing(() -> obj.set(supp.get()), first, more);
        }
        catch (Exception ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
        return (T)obj.get();
    }

    default public <T> T getLocking(Supplier<T> supp, BitSet slots) throws InterruptedException {
        Obj obj = Obj.create();
        this.locking(() -> obj.set(supp.get()), slots);
        return (T)obj.get();
    }

    default public <T> T getLockingThrowing(ThrowingSupplier<T> supp, BitSet slots) throws Exception {
        Obj obj = Obj.create();
        this.lockingThrowing(() -> obj.set(supp.get()), slots);
        return (T)obj.get();
    }

    default public <T> T getLockingIO(IOSupplier<T> supp, BitSet slots) throws InterruptedException, IOException {
        Obj obj = Obj.create();
        try {
            this.lockingThrowing(() -> obj.set(supp.get()), slots);
        }
        catch (Exception ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
        return (T)obj.get();
    }

    default public long locking(LongSupplier supp, int first, int ... more) throws InterruptedException {
        Lng lng = Lng.create();
        this.locking(() -> lng.set(supp.getAsLong()), first, more);
        return lng.get();
    }

    default public int locking(IntSupplier supp, int first, int ... more) throws InterruptedException {
        Int in = Int.create();
        this.locking(() -> in.set(supp.getAsInt()), first, more);
        return in.get();
    }

    default public long lockingIO(IOLongSupplier supp, int first, int ... more) throws InterruptedException, IOException {
        Lng lng = Lng.create();
        try {
            this.lockingThrowing(() -> lng.set(supp.getAsLong()), first, more);
        }
        catch (Exception ex) {
            return (Long)Exceptions.chuck((Throwable)ex);
        }
        return lng.get();
    }

    default public int lockingIO(IOIntSupplier supp, int first, int ... more) throws InterruptedException, IOException {
        Int in = Int.create();
        try {
            this.lockingThrowing(() -> in.set(supp.getAsInt()), first, more);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }

    default public long lockingThrowing(ThrowingLongSupplier supp, int first, int ... more) throws Exception {
        Lng lng = Lng.create();
        this.lockingThrowing(() -> lng.set(supp.getAsLong()), first, more);
        return lng.get();
    }

    default public int lockingThrowing(ThrowingIntSupplier supp, int first, int ... more) throws Exception {
        Int in = Int.create();
        try {
            this.lockingThrowing(() -> in.set(supp.getAsInt()), first, more);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }

    default public long locking(LongSupplier supp, BitSet slots) throws InterruptedException {
        Lng lng = Lng.create();
        this.locking(() -> lng.set(supp.getAsLong()), slots);
        return lng.get();
    }

    default public int locking(IntSupplier supp, BitSet slots) throws InterruptedException {
        Int in = Int.create();
        this.locking(() -> in.set(supp.getAsInt()), slots);
        return in.get();
    }

    default public long lockingIO(IOLongSupplier supp, BitSet slots) throws InterruptedException, IOException {
        Lng lng = Lng.create();
        try {
            this.lockingThrowing(() -> lng.set(supp.getAsLong()), slots);
        }
        catch (Exception ex) {
            return (Long)Exceptions.chuck((Throwable)ex);
        }
        return lng.get();
    }

    default public int lockingIO(IOIntSupplier supp, BitSet slots) throws InterruptedException, IOException {
        Int in = Int.create();
        try {
            this.lockingThrowing(() -> in.set(supp.getAsInt()), slots);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }

    default public long lockingThrowing(ThrowingLongSupplier supp, BitSet slots) throws Exception {
        Lng lng = Lng.create();
        this.lockingThrowing(() -> lng.set(supp.getAsLong()), slots);
        return lng.get();
    }

    default public int lockingThrowing(ThrowingIntSupplier supp, BitSet slots) throws Exception {
        Int in = Int.create();
        try {
            this.lockingThrowing(() -> in.set(supp.getAsInt()), slots);
        }
        catch (Exception ex) {
            return (Integer)Exceptions.chuck((Throwable)ex);
        }
        return in.get();
    }
}

