/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.stats;

import com.mastfrog.concurrent.stats.ConcurrentIntegerStats;
import com.mastfrog.concurrent.stats.StatisticCollector;
import com.mastfrog.function.IntQuadConsumer;
import com.mastfrog.util.preconditions.Checks;
import java.util.IntSummaryStatistics;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;

public interface IntegerStatisticCollector
extends StatisticCollector<IntConsumer, IntQuadConsumer>,
IntConsumer {
    default public IntegerStatisticCollector add(int value) {
        this.accept(value);
        return this;
    }

    public IntSummaryStatistics toStatistics();

    public static IntegerStatisticCollector create(int samples) {
        return new ConcurrentIntegerStats(samples);
    }

    default public IntegerStatisticCollector intermittentlySampling(Random rnd, int oneIn) {
        Checks.greaterThanZero((String)"oneIn", (int)oneIn);
        return this.intermittentlySampling(() -> rnd.nextInt(oneIn) == 1);
    }

    default public IntegerStatisticCollector intermittentlySampling(final BooleanSupplier shouldSample) {
        return new IntegerStatisticCollector(){

            @Override
            public boolean isEmpty() {
                return IntegerStatisticCollector.this.isEmpty();
            }

            @Override
            public int capacity() {
                return IntegerStatisticCollector.this.capacity();
            }

            @Override
            public void reset() {
                IntegerStatisticCollector.this.reset();
            }

            @Override
            public double average() {
                return IntegerStatisticCollector.this.average();
            }

            @Override
            public int forEach(IntConsumer consumer) {
                return IntegerStatisticCollector.this.forEach(consumer);
            }

            @Override
            public boolean withStats(IntQuadConsumer c) {
                return IntegerStatisticCollector.this.withStats(c);
            }

            @Override
            public boolean withStatsAndValues(IntConsumer valueVisitor, IntQuadConsumer statsConsumer) {
                return IntegerStatisticCollector.this.withStatsAndValues(valueVisitor, statsConsumer);
            }

            @Override
            public boolean median(IntConsumer c) {
                return IntegerStatisticCollector.this.median(c);
            }

            @Override
            public void accept(int value) {
                if (shouldSample.getAsBoolean()) {
                    IntegerStatisticCollector.this.accept(value);
                }
            }

            @Override
            public IntegerStatisticCollector add(int value) {
                this.accept(value);
                return this;
            }

            @Override
            public IntSummaryStatistics toStatistics() {
                return IntegerStatisticCollector.this.toStatistics();
            }
        };
    }
}

