/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import com.mastfrog.concurrent.AtomicIntegerPair;
import com.mastfrog.concurrent.IntegerPair;
import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.function.IntBiPredicate;
import com.mastfrog.function.state.Lng;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.IntUnaryOperator;

public class AtomicIntegerPairArray {
    private final AtomicLongArray arr;

    private AtomicIntegerPairArray(int size) {
        this.arr = new AtomicLongArray(size);
    }

    private AtomicIntegerPairArray(AtomicIntegerPairArray orig) {
        int sz = orig.size();
        AtomicLongArray a = this.arr = new AtomicLongArray(sz);
        for (int i = 0; i < sz; ++i) {
            a.set(i, orig.arr.get(i));
        }
    }

    private AtomicIntegerPairArray(int[] pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of array entries: " + pairs.length);
        }
        this.arr = new AtomicLongArray(pairs.length / 2);
        for (int i = 0; i < pairs.length; i += 2) {
            this.arr.set(i / 2, AtomicIntegerPair.pack(pairs[i], pairs[i + 1]));
        }
    }

    private AtomicIntegerPairArray(long[] items) {
        this.arr = new AtomicLongArray(items);
    }

    public static AtomicIntegerPairArray from(long[] items) {
        return new AtomicIntegerPairArray(items);
    }

    public static AtomicIntegerPairArray from(int[] items) {
        return new AtomicIntegerPairArray(items);
    }

    public static AtomicIntegerPairArray create(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size " + size);
        }
        return new AtomicIntegerPairArray(size);
    }

    public AtomicIntegerPairArray copy() {
        return new AtomicIntegerPairArray(this);
    }

    public AtomicIntegerPairArray copyOfRange(int start, int lengthToCopy, int size) {
        AtomicIntegerPairArray nue = new AtomicIntegerPairArray(size);
        for (int i = start; i < start + lengthToCopy && i - start < size; ++i) {
            nue.arr.set(i - start, this.arr.get(i));
        }
        return nue;
    }

    public int setFirst(int leftValue, int rightValue, IntBiPredicate cellTest) {
        int sz = this.size();
        long newVal = AtomicIntegerPair.pack(leftValue, rightValue);
        for (int i = 0; i < sz; ++i) {
            long val = this.arr.get(i);
            if (!cellTest.test(AtomicIntegerPair.unpackLeft(val), AtomicIntegerPair.unpackRight(val)) || !this.arr.compareAndSet(i, val, newVal)) continue;
            return i;
        }
        return -1;
    }

    public void fill(int left, int right) {
        int sz = this.size();
        long value = AtomicIntegerPair.pack(left, right);
        for (int i = 0; i < sz; ++i) {
            this.arr.set(i, value);
        }
    }

    public int size() {
        return this.arr.length();
    }

    public int left(int index) {
        return AtomicIntegerPair.unpackLeft(this.arr.get(index));
    }

    public int right(int index) {
        return AtomicIntegerPair.unpackRight(this.arr.get(index));
    }

    public int setLeft(int index, int newLeft) {
        return AtomicIntegerPair.unpackLeft(this.arr.getAndUpdate(index, old -> {
            int oldRight = AtomicIntegerPair.unpackRight(old);
            return AtomicIntegerPair.pack(newLeft, oldRight);
        }));
    }

    public int setRight(int index, int newRight) {
        return AtomicIntegerPair.unpackRight(this.arr.getAndUpdate(index, old -> {
            int oldLeft = AtomicIntegerPair.unpackLeft(old);
            return AtomicIntegerPair.pack(oldLeft, newRight);
        }));
    }

    public void fetch(int index, IntBiConsumer c) {
        long val = this.arr.get(index);
        c.accept(AtomicIntegerPair.unpackLeft(val), AtomicIntegerPair.unpackRight(val));
    }

    public void update(int index, IntUnaryOperator leftFunction, IntUnaryOperator rightFunction) {
        this.arr.updateAndGet(index, old -> {
            int left = leftFunction.applyAsInt(AtomicIntegerPair.unpackLeft(old));
            int right = rightFunction.applyAsInt(AtomicIntegerPair.unpackRight(old));
            return AtomicIntegerPair.pack(left, right);
        });
    }

    public void update(int index, IntegerPair.IntegerPairUpdater updater) {
        Lng val = Lng.create();
        this.arr.updateAndGet(index, old -> {
            val.set(old);
            updater.update(AtomicIntegerPair.unpackLeft(old), AtomicIntegerPair.unpackRight(old), (newLeft, newRight) -> val.set(AtomicIntegerPair.pack(newLeft, newRight)));
            return val.getAsLong();
        });
    }

    public boolean compareAndSet(int index, int expectedLeftValue, int expectedRightValue, int leftValue, int rightValue) {
        long expect = AtomicIntegerPair.pack(expectedLeftValue, expectedRightValue);
        long nue = AtomicIntegerPair.pack(leftValue, rightValue);
        return this.arr.compareAndSet(index, expect, nue);
    }

    public void set(int index, int left, int right) {
        this.arr.set(index, AtomicIntegerPair.pack(left, right));
    }

    public int each(IntBiPredicate pred) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            long val = this.arr.get(i);
            if (pred.test(AtomicIntegerPair.unpackLeft(val), AtomicIntegerPair.unpackRight(val))) continue;
            return i;
        }
        return sz - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size(); ++i) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            long val = this.arr.get(i);
            sb.append('(').append(AtomicIntegerPair.unpackLeft(val)).append(',').append(AtomicIntegerPair.unpackRight(val)).append(')');
        }
        return sb.append(']').toString();
    }

    public int[] toIntArray() {
        int sz = this.size();
        int[] result = new int[sz * 2];
        for (int i = 0; i < sz; ++i) {
            long val = this.arr.get(i);
            int offset = i * 2;
            result[offset] = AtomicIntegerPair.unpackLeft(val);
            result[offset + 1] = AtomicIntegerPair.unpackRight(val);
        }
        return result;
    }

    public long[] toLongArray() {
        int sz = this.size();
        long[] result = new long[sz];
        for (int i = 0; i < sz; ++i) {
            result[i] = this.arr.get(i);
        }
        return result;
    }

    public IntegerPair pairView(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Index " + index + " is out of range 0-" + this.size());
        }
        return new IntegerPairView(index);
    }

    class IntegerPairView
    implements IntegerPair {
        private final int index;

        public IntegerPairView(int index) {
            this.index = index;
        }

        @Override
        public boolean compareAndSet(int expectedLeftValue, int expectedRightValue, int newLeftValue, int newRightValue) {
            return AtomicIntegerPairArray.this.compareAndSet(this.index, expectedLeftValue, expectedRightValue, newLeftValue, newRightValue);
        }

        @Override
        public void fetch(IntBiConsumer pair) {
            AtomicIntegerPairArray.this.fetch(this.index, pair);
        }

        @Override
        public int left() {
            return AtomicIntegerPairArray.this.left(this.index);
        }

        @Override
        public int right() {
            return AtomicIntegerPairArray.this.right(this.index);
        }

        @Override
        public void set(int left, int right) {
            AtomicIntegerPairArray.this.set(this.index, left, right);
        }

        @Override
        public void setLeft(int newLeft) {
            AtomicIntegerPairArray.this.setLeft(this.index, newLeft);
        }

        @Override
        public void setRight(int newRight) {
            AtomicIntegerPairArray.this.setRight(this.index, newRight);
        }

        @Override
        public long toLong() {
            return AtomicIntegerPairArray.this.arr.get(this.index);
        }

        @Override
        public void update(IntUnaryOperator leftFunction, IntUnaryOperator rightFunction) {
            AtomicIntegerPairArray.this.update(this.index, leftFunction, rightFunction);
        }

        public String toString() {
            return this.index + ":(" + this.left() + "," + this.right() + ")";
        }

        @Override
        public void update(IntegerPair.IntegerPairUpdater pairUpdater) {
            AtomicIntegerPairArray.this.update(this.index, pairUpdater);
        }
    }
}

