/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import com.mastfrog.concurrent.AtomicIntegerPair;
import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.function.state.Bool;
import java.util.function.IntConsumer;

public class AtomicMinMax
implements IntConsumer {
    private final AtomicIntegerPair pair = new AtomicIntegerPair(Integer.MAX_VALUE, Integer.MIN_VALUE);

    public AtomicMinMax() {
    }

    public AtomicMinMax(int initialValue) {
        this.pair.set(initialValue, initialValue);
    }

    public AtomicMinMax reset() {
        this.pair.set(Integer.MAX_VALUE, Integer.MIN_VALUE);
        return this;
    }

    public boolean isSet() {
        return this.get((_ignored1, _ignored2) -> {});
    }

    @Override
    public void accept(int newValue) {
        this.pair.update(oldMin -> Math.min(oldMin, newValue), oldMax -> Math.max(oldMax, newValue));
    }

    public boolean get(IntBiConsumer minMax) {
        Bool called = Bool.create();
        this.pair.fetch((min, max) -> {
            if (min <= max) {
                called.set();
                minMax.accept(min, max);
            }
        });
        return called.getAsBoolean();
    }

    public int min() {
        return this.pair.left();
    }

    public int max() {
        return this.pair.right();
    }

    public String toString() {
        return "MinMax" + this.pair;
    }

    public IntConsumer wrap(IntConsumer other) {
        return val -> {
            this.accept(val);
            other.accept(val);
        };
    }
}

