/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent;

import com.mastfrog.concurrent.IntegerPair;
import com.mastfrog.concurrent.UnsignedView;
import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.function.LongBiConsumer;
import java.util.function.LongUnaryOperator;

final class UnsignedViewImpl
implements UnsignedView {
    private final IntegerPair delegate;

    UnsignedViewImpl(IntegerPair delegate) {
        this.delegate = delegate;
    }

    private int toInt(long value) {
        if (value < 0L || value > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("Value out of range 0-4294967294");
        }
        return (int)value;
    }

    private long toLong(int value) {
        long unsigned = (long)value & 0xFFFFFFFFL;
        return unsigned;
    }

    @Override
    public boolean compareAndSet(long expectedLeftValue, long expectedRightValue, long newLeftValue, long newRightValue) {
        return this.delegate.compareAndSet(this.toInt(expectedLeftValue), this.toInt(expectedRightValue), this.toInt(newLeftValue), this.toInt(newRightValue));
    }

    @Override
    public long left() {
        return this.toLong(this.delegate.left());
    }

    @Override
    public long right() {
        return this.toLong(this.delegate.right());
    }

    @Override
    public void set(long left, long right) {
        this.delegate.set(this.toInt(left), this.toInt(right));
    }

    @Override
    public void setLeft(long newLeft) {
        this.delegate.setLeft(this.toInt(newLeft));
    }

    @Override
    public void setRight(long newRight) {
        this.delegate.setRight(this.toInt(newRight));
    }

    @Override
    public long toLong() {
        return this.delegate.toLong();
    }

    @Override
    public void update(LongUnaryOperator leftFunction, LongUnaryOperator rightFunction) {
        this.delegate.update((int oldLeft) -> this.toInt(leftFunction.applyAsLong(this.toLong(oldLeft))), (int oldRight) -> this.toInt(rightFunction.applyAsLong(this.toLong(oldRight))));
    }

    public String toString() {
        return "(" + this.left() + ", " + this.right() + ")";
    }

    @Override
    public void fetch(LongBiConsumer consumer) {
        this.delegate.fetch((l, r) -> consumer.accept(this.toLong(l), this.toLong(r)));
    }

    @Override
    public void update(UnsignedView.UnsignedPairUpdater updater) {
        this.delegate.update((int l, int r, IntBiConsumer updateReceiver) -> updater.update(this.toLong(l), this.toLong(r), (a, b) -> updateReceiver.accept(this.toInt(a), this.toInt(b))));
    }
}

