/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.future;

import com.mastfrog.concurrent.future.AwaitableCompletionStage;
import com.mastfrog.function.state.Obj;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

final class AwaitableCompletionStageImpl<T>
implements AwaitableCompletionStage<T> {
    private final CompletionStage<T> future;

    AwaitableCompletionStageImpl(CompletionStage<T> future) {
        this.future = (CompletionStage)Checks.notNull((String)"future", future);
    }

    @Override
    public final <U> AwaitableCompletionStage<U> thenApply(Function<? super T, ? extends U> fn) {
        return AwaitableCompletionStage.of(this.future.thenApply(fn));
    }

    @Override
    public final <U> AwaitableCompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return AwaitableCompletionStage.of(this.future.thenApplyAsync(fn));
    }

    @Override
    public final <U> AwaitableCompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return AwaitableCompletionStage.of(this.future.thenApplyAsync(fn, executor));
    }

    @Override
    public final CompletionStage<Void> thenAccept(Consumer<? super T> action) {
        return this.future.thenAccept(action);
    }

    @Override
    public final CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.future.thenAcceptAsync(action);
    }

    @Override
    public final CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.future.thenAcceptAsync(action, executor);
    }

    @Override
    public final CompletionStage<Void> thenRun(Runnable action) {
        return this.future.thenRun(action);
    }

    @Override
    public final CompletionStage<Void> thenRunAsync(Runnable action) {
        return this.future.thenRunAsync(action);
    }

    @Override
    public final CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.future.thenRunAsync(action, executor);
    }

    @Override
    public final <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.future.thenCombine(other, fn);
    }

    @Override
    public final <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.future.thenCombineAsync(other, fn);
    }

    @Override
    public final <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.future.thenCombineAsync(other, fn, executor);
    }

    @Override
    public final <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.future.thenAcceptBoth(other, action);
    }

    @Override
    public final <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.future.thenAcceptBothAsync(other, action);
    }

    @Override
    public final <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.future.thenAcceptBothAsync(other, action, executor);
    }

    @Override
    public final CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBoth(other, action);
    }

    @Override
    public final CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync(other, action);
    }

    @Override
    public final CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterBothAsync(other, action, executor);
    }

    @Override
    public final <U> CompletionStage<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.future.applyToEither(other, fn);
    }

    @Override
    public final <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.future.applyToEitherAsync(other, fn);
    }

    @Override
    public final <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.future.applyToEitherAsync(other, fn, executor);
    }

    @Override
    public final CompletionStage<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.future.acceptEither(other, action);
    }

    @Override
    public final CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.future.acceptEitherAsync(other, action);
    }

    @Override
    public final CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.future.acceptEitherAsync(other, action, executor);
    }

    @Override
    public final CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEither(other, action);
    }

    @Override
    public final CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync(other, action);
    }

    @Override
    public final CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterEitherAsync(other, action, executor);
    }

    @Override
    public final <U> AwaitableCompletionStage<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return AwaitableCompletionStage.of(this.future.thenCompose(fn));
    }

    @Override
    public final <U> AwaitableCompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return AwaitableCompletionStage.of(this.future.thenComposeAsync(fn));
    }

    @Override
    public final <U> AwaitableCompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return AwaitableCompletionStage.of(this.future.thenComposeAsync(fn, executor));
    }

    @Override
    public final <U> AwaitableCompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return AwaitableCompletionStage.of(this.future.handle(fn));
    }

    @Override
    public final <U> AwaitableCompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return AwaitableCompletionStage.of(this.future.handleAsync(fn));
    }

    @Override
    public final <U> AwaitableCompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return AwaitableCompletionStage.of(this.future.handleAsync(fn, executor));
    }

    @Override
    public final AwaitableCompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return AwaitableCompletionStage.of(this.future.whenComplete(action));
    }

    @Override
    public final AwaitableCompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return AwaitableCompletionStage.of(this.future.whenCompleteAsync(action));
    }

    @Override
    public final AwaitableCompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return AwaitableCompletionStage.of(this.future.whenCompleteAsync(action, executor));
    }

    @Override
    public final CompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.future.exceptionally(fn);
    }

    @Override
    public final CompletableFuture<T> toCompletableFuture() {
        return this.future.toCompletableFuture();
    }

    public final String toString() {
        return this.future.toString();
    }

    @Override
    public T await() throws InterruptedException {
        Obj rethrow = Obj.createAtomic();
        Obj result = Obj.createAtomic();
        CountDownLatch latch = new CountDownLatch(1);
        this.future.whenCompleteAsync((? super T obj, ? super Throwable thrown) -> {
            try {
                if (thrown != null) {
                    rethrow.set(thrown);
                } else if (obj != null) {
                    result.set(obj);
                }
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        rethrow.ifNotNull(thrown -> Exceptions.chuck((Throwable)thrown));
        return (T)result.get();
    }

    @Override
    public T await(long amount, TimeUnit unit) throws InterruptedException {
        Obj rethrow = Obj.createAtomic();
        Obj result = Obj.createAtomic();
        CountDownLatch latch = new CountDownLatch(1);
        this.future.whenCompleteAsync((? super T obj, ? super Throwable thrown) -> {
            try {
                result.set(obj);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await(amount, unit);
        rethrow.ifNotNull(thrown -> Exceptions.chuck((Throwable)thrown));
        return (T)result.get();
    }
}

