/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.stats;

import com.mastfrog.concurrent.stats.LongStatisticCollector;
import com.mastfrog.function.LongQuadConsumer;
import com.mastfrog.function.state.Dbl;
import com.mastfrog.function.state.Int;
import com.mastfrog.function.state.Lng;
import com.mastfrog.util.preconditions.Checks;
import java.util.Arrays;
import java.util.LongSummaryStatistics;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.LongConsumer;

final class ConcurrentLongStats
implements LongConsumer,
LongStatisticCollector {
    private final AtomicLongArray arr;
    private final AtomicInteger tail = new AtomicInteger();

    public ConcurrentLongStats(int ringSize) {
        this.arr = new AtomicLongArray(Checks.greaterThanOne((String)"ringSize", (int)ringSize));
    }

    public ConcurrentLongStats copy() {
        ConcurrentLongStats result = new ConcurrentLongStats(this.arr.length());
        result.tail.set(this.tail.get());
        for (int i = 0; i < this.capacity(); ++i) {
            result.arr.set(i, this.arr.get(i));
        }
        return result;
    }

    @Override
    public double average() {
        Dbl dbl = Dbl.create();
        double count = this.forEach((long val) -> dbl.add((double)val));
        return count > 0.0 ? dbl.getAsDouble() / count : 0.0;
    }

    @Override
    public boolean median(LongConsumer c) {
        int count = this.sampleCount();
        if (count < 3) {
            return false;
        }
        long[] vals = new long[this.sampleCount()];
        Int cursor = Int.create();
        this.forEach((long val) -> {
            int ct = cursor.increment(1);
            if (ct < vals.length) {
                vals[ct] = val;
            }
        });
        Arrays.sort(vals);
        long mid = vals[vals.length / 2];
        c.accept(mid);
        return true;
    }

    @Override
    public int capacity() {
        return this.arr.length();
    }

    @Override
    public boolean isEmpty() {
        return this.tail.get() == 0;
    }

    @Override
    public void reset() {
        this.tail.set(0);
    }

    @Override
    public LongSummaryStatistics toStatistics() {
        LongSummaryStatistics result = new LongSummaryStatistics();
        this.forEach(result);
        return result;
    }

    public int sampleCount() {
        return Math.abs(this.tail.get());
    }

    private int next() {
        int count = this.arr.length();
        int resultBase = this.tail.updateAndGet(old -> {
            if (old == 0) {
                return -1;
            }
            if (old < 0) {
                int next = old - 1;
                if (next < -count) {
                    return 1;
                }
                return next;
            }
            int next = old + 1;
            if (next >= count + 1) {
                return 1;
            }
            return next;
        });
        return Math.abs(resultBase) - 1;
    }

    int addValue(long val) {
        int result = this.next();
        this.arr.set(result, val);
        return result;
    }

    @Override
    public int forEach(LongConsumer consumer) {
        int t = this.tail.get();
        if (t == 0) {
            return 0;
        }
        if (t < 0) {
            for (int i = -1; i >= t; --i) {
                int ix = -i - 1;
                consumer.accept(this.arr.get(ix));
            }
            return -t;
        }
        int len = this.arr.length();
        for (int i = 0; i < len; ++i) {
            consumer.accept(this.arr.get(i));
        }
        return len;
    }

    @Override
    public boolean withStats(LongQuadConsumer c) {
        return this.withStatsAndValues(null, c);
    }

    @Override
    public boolean withStatsAndValues(LongConsumer valueVisitor, LongQuadConsumer statsConsumer) {
        boolean result;
        Int callCount;
        Lng sum;
        Lng max;
        Lng min = Lng.of((long)Long.MAX_VALUE);
        int count = this.forEach(arg_0 -> ConcurrentLongStats.lambda$withStatsAndValues$3(min, max = Lng.of((long)Long.MIN_VALUE), sum = Lng.create(), callCount = Int.create(), valueVisitor, arg_0));
        boolean bl = result = count != 0;
        if (result) {
            statsConsumer.accept(min.getAsLong(), max.getAsLong(), sum.getAsLong(), (long)callCount.get().intValue());
        }
        return result;
    }

    @Override
    public void accept(int value) {
        this.addValue(value);
    }

    @Override
    public void accept(long value) {
        this.addValue(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("long-stats{");
        boolean any = this.withStatsAndValues((long val) -> sb.append(' ').append(val), (min, max, sum, count) -> sb.append(" min=").append(min).append(" max=").append(max).append(" sum=").append(sum).append(" count=").append(count));
        if (!any) {
            sb.append("-empty-");
        }
        return sb.append('}').toString();
    }

    private static /* synthetic */ void lambda$withStatsAndValues$3(Lng min, Lng max, Lng sum, Int callCount, LongConsumer valueVisitor, long val) {
        min.min(val);
        max.max(val);
        sum.incrementSafe(val);
        callCount.increment();
        if (valueVisitor != null) {
            valueVisitor.accept(val);
        }
    }
}

