/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.concurrent.stats;

import com.mastfrog.concurrent.stats.ConcurrentLongStats;
import com.mastfrog.concurrent.stats.StatisticCollector;
import com.mastfrog.function.LongQuadConsumer;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import java.util.LongSummaryStatistics;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public interface LongStatisticCollector
extends StatisticCollector<LongConsumer, LongQuadConsumer>,
LongConsumer,
IntConsumer {
    default public LongStatisticCollector add(long value) {
        this.accept(value);
        return this;
    }

    public static LongStatisticCollector create(int samples) {
        return new ConcurrentLongStats(samples);
    }

    public LongSummaryStatistics toStatistics();

    default public LongStatisticCollector intermittentlySampling(Random rnd, int oneIn) {
        Checks.greaterThanZero((String)"oneIn", (int)oneIn);
        return this.intermittentlySampling(() -> rnd.nextInt(oneIn) == 1);
    }

    default public LongStatisticCollector time(TimeUnit unit, Runnable r) {
        try {
            return this.timeThrowing(unit, true, () -> r.run());
        }
        catch (Exception ex) {
            return (LongStatisticCollector)Exceptions.chuck((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public LongStatisticCollector timeThrowing(TimeUnit unit, boolean recordFailed, ThrowingRunnable r) throws Exception {
        LongStatisticCollector longStatisticCollector;
        block5: {
            long now;
            boolean failed = false;
            boolean nanos = unit == TimeUnit.MICROSECONDS || unit == TimeUnit.NANOSECONDS;
            long then = nanos ? System.nanoTime() : System.currentTimeMillis();
            try {
                r.run();
                longStatisticCollector = this;
                if (failed && !recordFailed) break block5;
                now = nanos ? System.nanoTime() : System.currentTimeMillis();
            }
            catch (Error | Exception ex) {
                LongStatisticCollector longStatisticCollector2;
                block6: {
                    long now2;
                    try {
                        failed = true;
                        longStatisticCollector2 = (LongStatisticCollector)Exceptions.chuck((Throwable)ex);
                        if (failed && !recordFailed) break block6;
                        now2 = nanos ? System.nanoTime() : System.currentTimeMillis();
                    }
                    catch (Throwable throwable) {
                        if (!failed || recordFailed) {
                            long now3 = nanos ? System.nanoTime() : System.currentTimeMillis();
                            long elapsed = now3 - then;
                            long value = unit.convert(elapsed, nanos ? TimeUnit.NANOSECONDS : TimeUnit.MILLISECONDS);
                            this.accept(value);
                        }
                        throw throwable;
                    }
                    long elapsed = now2 - then;
                    long value = unit.convert(elapsed, nanos ? TimeUnit.NANOSECONDS : TimeUnit.MILLISECONDS);
                    this.accept(value);
                }
                return longStatisticCollector2;
            }
            long elapsed = now - then;
            long value = unit.convert(elapsed, nanos ? TimeUnit.NANOSECONDS : TimeUnit.MILLISECONDS);
            this.accept(value);
        }
        return longStatisticCollector;
    }

    default public LongStatisticCollector intermittentlySampling(final BooleanSupplier shouldSample) {
        return new LongStatisticCollector(){

            @Override
            public boolean isEmpty() {
                return LongStatisticCollector.this.isEmpty();
            }

            @Override
            public int capacity() {
                return LongStatisticCollector.this.capacity();
            }

            @Override
            public void reset() {
                LongStatisticCollector.this.reset();
            }

            @Override
            public double average() {
                return LongStatisticCollector.this.average();
            }

            @Override
            public int forEach(LongConsumer consumer) {
                return LongStatisticCollector.this.forEach(consumer);
            }

            @Override
            public boolean withStats(LongQuadConsumer c) {
                return LongStatisticCollector.this.withStats(c);
            }

            @Override
            public boolean withStatsAndValues(LongConsumer valueVisitor, LongQuadConsumer statsConsumer) {
                return LongStatisticCollector.this.withStatsAndValues(valueVisitor, statsConsumer);
            }

            @Override
            public boolean median(LongConsumer c) {
                return LongStatisticCollector.this.median(c);
            }

            @Override
            public void accept(long value) {
                if (shouldSample.getAsBoolean()) {
                    LongStatisticCollector.this.accept(value);
                }
            }

            @Override
            public void accept(int value) {
                this.accept((long)value);
            }

            @Override
            public LongStatisticCollector add(long value) {
                this.accept(value);
                return this;
            }

            @Override
            public LongSummaryStatistics toStatistics() {
                return LongStatisticCollector.this.toStatistics();
            }
        };
    }
}

