/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.util.Providers;
import com.mastfrog.abstractions.instantiate.Instantiator;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.function.threadlocal.ThreadLocalValue;
import com.mastfrog.giulius.DependenciesBuilder;
import com.mastfrog.giulius.DeploymentMode;
import com.mastfrog.giulius.SettingsBindings;
import com.mastfrog.giulius.ShutdownHookRegistry;
import com.mastfrog.giulius.ShutdownHooks;
import com.mastfrog.giulius.annotations.Namespace;
import com.mastfrog.giulius.annotations.Value;
import com.mastfrog.settings.MutableSettings;
import com.mastfrog.settings.Settings;
import com.mastfrog.settings.SettingsBuilder;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.ConfigurationError;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.streams.Streams;
import com.mastfrog.util.time.TimeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Dependencies
implements Instantiator {
    public static final String SETTINGS_KEY_SHUTDOWN_HOOK_EXECUTOR_WAIT = "shutdownHookExecutorWait";
    public static final String SYSTEM_PROP_PRODUCTION_MODE = "productionMode";
    public static final String IDE_MODE_SYSTEM_PROPERTY = "in.ide";
    private static final Pattern PARENT_PACKAGE_PATTERN = Pattern.compile("(.*)\\..*?");
    static final ThreadLocalValue<TypeLiteral<?>> currentType = ThreadLocalValue.create();
    static final ThreadLocalValue<TypeLiteral<?>> prevType = ThreadLocalValue.create();
    private final Map<String, Settings> settings = new HashMap<String, Settings>();
    private final Set<SettingsBindings> settingsBindings;
    private final List<Module> modules = new LinkedList<Module>();
    private volatile Injector injector;
    private final ThreadLocalCounter ctr = new ThreadLocalCounter();
    private final boolean mergeNamespaces;
    private final ShutdownHookRegistry reg = ShutdownHookRegistry.get();
    private final Set<Dependencies> others = Collections.synchronizedSet(new HashSet());
    private long shutdownHookWaitMillis;

    public Dependencies(Module ... modules) throws IOException {
        this(SettingsBuilder.createDefault().build(), modules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append(" {\n");
        Iterator<Module> it = this.modules.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("\n");
        for (Map.Entry<String, Settings> e : this.settings.entrySet()) {
            sb.append("  ").append(e.getKey()).append("=").append(e.getValue()).append('\n');
        }
        return sb.append("\n}").toString();
    }

    public static Dependencies create(Module ... modules) {
        try {
            return new Dependencies(modules);
        }
        catch (IOException ioe) {
            throw new ConfigurationError((Throwable)ioe);
        }
    }

    public Dependencies(Settings configuration, Module ... modules) {
        this(false, Collections.singletonMap("defaults", configuration), EnumSet.allOf(SettingsBindings.class), modules);
    }

    Dependencies(boolean mergeNamespaces, Map<String, Settings> settings, Set<SettingsBindings> settingsBindings, Module ... modules) {
        this.mergeNamespaces = mergeNamespaces;
        this.settings.putAll(settings);
        if (!this.settings.containsKey("defaults")) {
            try {
                this.settings.put("defaults", new SettingsBuilder().build());
            }
            catch (IOException ex) {
                throw new ConfigurationError((Throwable)ex);
            }
        }
        this.modules.add(this.createBindings());
        this.modules.addAll(Arrays.asList(modules));
        this.settingsBindings = settingsBindings;
    }

    public static DependenciesBuilder builder() {
        return new DependenciesBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getInjector() {
        if (this.injector == null) {
            if (this.getStage() == Stage.PRODUCTION) {
                this.injector = Guice.createInjector((Stage)this.getStage(), this.modules);
            } else {
                Dependencies dependencies = this;
                synchronized (dependencies) {
                    try (ThreadLocalCounter c = this.ctr.enter();){
                        if (c.get() > 1) {
                            throw new IllegalStateException("Reentrant call to getInjector() on one thread.Something is asking for an instance of Dependencies or the Injector while the injector is being initialized - probably an eager singleton.  The injector may not be created twice.");
                        }
                        if (this.injector == null) {
                            this.injector = Guice.createInjector((Stage)this.getStage(), this.modules);
                        }
                    }
                }
            }
        }
        return this.injector;
    }

    void setShutdownHookExecutorWaitMillis(long shutdownHookExecutorWaitMillis) {
        this.shutdownHookWaitMillis = shutdownHookExecutorWaitMillis;
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.getInjector().getInstance(type);
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.getInjector().getInstance(key);
    }

    public void shutdown() {
        try {
            this.reg.shutdown();
        }
        finally {
            for (Dependencies d : this.others) {
                d.shutdown();
            }
        }
    }

    public static Module createBindings(Settings config) throws IOException {
        return new Dependencies(config, new Module[0]).createBindings();
    }

    protected Module createBindings() {
        return new DependenciesModule();
    }

    public boolean isProductionMode() {
        return Dependencies.isProductionMode(this.settings.get("defaults"));
    }

    public static boolean isProductionMode(Settings settings) {
        try {
            return settings.getBoolean(SYSTEM_PROP_PRODUCTION_MODE, false) || Boolean.getBoolean(SYSTEM_PROP_PRODUCTION_MODE);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public Settings getSettings() {
        Settings result = this.settings.get("defaults");
        if (result == null) {
            result = this.settings.get(this.settings.keySet().iterator().next());
        }
        return result;
    }

    public Settings getSettings(String namespace) {
        Checks.notNull((String)"namespace", (Object)namespace);
        return this.settings.get(namespace);
    }

    public Stage getStage() {
        Dependencies.isIDEMode();
        return this.isProductionMode() ? Stage.PRODUCTION : Stage.DEVELOPMENT;
    }

    public static boolean isIDEMode() {
        return Boolean.getBoolean(IDE_MODE_SYSTEM_PROPERTY);
    }

    public void autoShutdownRefresh(SettingsBuilder sb) {
        this.reg.add(sb.onShutdownRunnable());
    }

    public void injectMembers(Object arg) {
        this.getInjector().injectMembers(arg);
    }

    public final Dependencies alsoShutdown(Dependencies other) {
        if (other == this) {
            throw new IllegalArgumentException("add to self");
        }
        this.others.add(other);
        return this;
    }

    static void log(String s) {
        if (Boolean.getBoolean(Dependencies.class.getName() + ".log")) {
            System.out.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> loadNamespaceListsFromClasspath() throws IOException {
        HashSet<String> all = new HashSet<String>();
        String listPathOnClasspath = "META-INF/settings/namespaces.list";
        InputStream[] streams = Streams.locate((String)listPathOnClasspath);
        if (streams != null) {
            for (InputStream in : streams) {
                try {
                    InputStreamReader reader = new InputStreamReader(in);
                    Dependencies.readNamepaces(reader, all);
                }
                finally {
                    in.close();
                }
            }
            Dependencies.log("Loaded namespace files: " + all);
        } else {
            Dependencies.log("No input streams for namespaces " + all + " - no classpath files " + listPathOnClasspath);
        }
        return all;
    }

    private static void readNamepaces(Reader reader, Set<? super String> into) throws IOException {
        String line = "";
        LineNumberReader r = new LineNumberReader(reader);
        while (line != null) {
            if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                into.add(line);
            }
            line = r.readLine();
        }
    }

    private static final class ThreadLocalCounter
    implements QuietAutoClosable {
        private final ThreadLocal<Integer> local = new ThreadLocal();

        private ThreadLocalCounter() {
        }

        public int get() {
            Integer result = this.local.get();
            return result == null ? 0 : result;
        }

        ThreadLocalCounter enter() {
            Integer val = this.local.get();
            if (val == null) {
                val = 0;
            }
            Integer n = val;
            val = val + 1;
            this.local.set(val);
            return this;
        }

        public void close() {
            Integer val = this.local.get();
            assert (val != null);
            Integer n = val;
            val = val - 1;
            if (val == 0) {
                this.local.remove();
            } else {
                this.local.set(val);
            }
        }
    }

    private final class DependenciesModule
    extends AbstractModule {
        private DependenciesModule() {
        }

        protected void configure() {
            try {
                boolean isUsingNamespaces;
                NamespacedSettingsProvider namespacedSettings;
                DeploymentMode mode;
                Binder binder = this.binder();
                this.bind(Dependencies.class).toInstance((Object)Dependencies.this);
                this.bind(Instantiator.class).toInstance((Object)Dependencies.this);
                this.bind(ShutdownHookRegistry.class).toInstance((Object)Dependencies.this.reg);
                this.bind(ShutdownHooks.class).toInstance((Object)Dependencies.this.reg);
                this.bind(com.mastfrog.shutdown.hooks.ShutdownHooks.class).toInstance((Object)Dependencies.this.reg.realHooks());
                this.bind(com.mastfrog.shutdown.hooks.ShutdownHookRegistry.class).toInstance((Object)Dependencies.this.reg.realHooks());
                Set<String> knownNamespaces = Dependencies.loadNamespaceListsFromClasspath();
                Dependencies.log("Loaded namespaces " + knownNamespaces);
                knownNamespaces.addAll(Dependencies.this.settings.keySet());
                knownNamespaces.add("defaults");
                Stage stage = Dependencies.this.getStage();
                switch (stage) {
                    case PRODUCTION: {
                        mode = DeploymentMode.PRODUCTION;
                        break;
                    }
                    default: {
                        mode = DeploymentMode.DEVELOPMENT;
                    }
                }
                this.bind(DeploymentMode.class).toInstance((Object)mode);
                Dependencies.this.reg.setDeploymentMode(mode);
                boolean onlyDefaultNamespace = knownNamespaces.isEmpty() || CollectionUtils.setOf((Object)"defaults").equals(knownNamespaces);
                HashSet allKeys = new HashSet();
                long shutdownTimeout = 0L;
                for (String namespace : knownNamespaces) {
                    Settings s = (Settings)Dependencies.this.settings.get(namespace);
                    if (s == null) {
                        s = SettingsBuilder.forNamespace((String)namespace).addGeneratedDefaultsFromClasspath().addDefaultsFromClasspath().build();
                        Dependencies.this.settings.put(namespace, s);
                    }
                    allKeys.addAll(s.allKeys());
                    Long shutdownWait = s.getLong(Dependencies.SETTINGS_KEY_SHUTDOWN_HOOK_EXECUTOR_WAIT);
                    if (shutdownWait == null) continue;
                    shutdownTimeout = Math.max(shutdownTimeout, shutdownWait);
                }
                long finalTimeout = shutdownTimeout == 0L ? Dependencies.this.shutdownHookWaitMillis : shutdownTimeout;
                Dependencies.this.reg.setWaitMilliseconds(Math.max(100L, shutdownTimeout));
                if (onlyDefaultNamespace) {
                    String ns = knownNamespaces.isEmpty() ? "defaults" : knownNamespaces.iterator().next();
                    namespacedSettings = Providers.of((Object)((Settings)Dependencies.this.settings.get(ns)));
                } else if (Dependencies.this.mergeNamespaces) {
                    SettingsBuilder sb = Settings.builder();
                    Settings s = (Settings)Dependencies.this.settings.get("defaults");
                    sb.add(s);
                    ArrayList sortedKeys = new ArrayList(Dependencies.this.settings.keySet());
                    Collections.sort(sortedKeys);
                    for (Object key : sortedKeys) {
                        if ("defaults".equals(key)) continue;
                        sb.add((Settings)Dependencies.this.settings.get(key));
                    }
                    namespacedSettings = Providers.of((Object)sb.build());
                } else {
                    namespacedSettings = new NamespacedSettingsProvider(Dependencies.this);
                }
                for (String k : allKeys) {
                    Named n = Names.named((String)k);
                    PropertyProvider p = new PropertyProvider(k, namespacedSettings);
                    for (SettingsBindings type : Dependencies.this.settingsBindings) {
                        switch (type) {
                            case INT: {
                                binder.bind(Key.get(Integer.class, (Annotation)n)).toProvider((Provider)new IntProvider(p));
                                break;
                            }
                            case STRING: {
                                binder.bind(Key.get(String.class, (Annotation)n)).toProvider((Provider)p);
                                break;
                            }
                            case LONG: {
                                binder.bind(Key.get(Long.class, (Annotation)n)).toProvider((Provider)new LongProvider(p));
                                break;
                            }
                            case BOOLEAN: {
                                binder.bind(Key.get(Boolean.class, (Annotation)n)).toProvider((Provider)new BooleanProvider(p));
                                break;
                            }
                            case BYTE: {
                                binder.bind(Key.get(Byte.class, (Annotation)n)).toProvider((Provider)new ByteProvider(p));
                                break;
                            }
                            case CHARACTER: {
                                binder.bind(Key.get(Character.class, (Annotation)n)).toProvider((Provider)new CharacterProvider(p));
                                break;
                            }
                            case DOUBLE: {
                                binder.bind(Key.get(Double.class, (Annotation)n)).toProvider((Provider)new DoubleProvider(p));
                                break;
                            }
                            case FLOAT: {
                                binder.bind(Key.get(Float.class, (Annotation)n)).toProvider((Provider)new FloatProvider(p));
                                break;
                            }
                            case SHORT: {
                                binder.bind(Key.get(Short.class, (Annotation)n)).toProvider((Provider)new ShortProvider(p));
                                break;
                            }
                            case BIG_DECIMAL: {
                                binder.bind(Key.get(BigDecimal.class, (Annotation)n)).toProvider((Provider)new BigDecimalProvider(p));
                                break;
                            }
                            case BIG_INTEGER: {
                                binder.bind(Key.get(BigInteger.class, (Annotation)n)).toProvider((Provider)new BigIntegerProvider(p));
                                break;
                            }
                            case DURATION: {
                                binder.bind(Key.get(Duration.class, (Annotation)n)).toProvider((Provider)new DurationProvider(p));
                            }
                        }
                    }
                }
                for (String namespace : knownNamespaces) {
                    Settings s = (Settings)Dependencies.this.settings.get(namespace);
                    this.bind(Settings.class).annotatedWith((Annotation)((Object)new NamespaceImpl(namespace))).toInstance((Object)s);
                    for (Object key : s) {
                        PropertyProvider p = new PropertyProvider((String)key, (Provider<Settings>)Providers.of((Object)s));
                        ValueImpl n = new ValueImpl((String)key, namespace);
                        for (SettingsBindings type : Dependencies.this.settingsBindings) {
                            switch (type) {
                                case INT: {
                                    binder.bind(Key.get(Integer.class, (Annotation)((Object)n))).toProvider((Provider)new IntProvider(p));
                                    break;
                                }
                                case STRING: {
                                    binder.bind(Key.get(String.class, (Annotation)((Object)n))).toProvider((Provider)p);
                                    break;
                                }
                                case LONG: {
                                    binder.bind(Key.get(Long.class, (Annotation)((Object)n))).toProvider((Provider)new LongProvider(p));
                                    break;
                                }
                                case BOOLEAN: {
                                    binder.bind(Key.get(Boolean.class, (Annotation)((Object)n))).toProvider((Provider)new BooleanProvider(p));
                                    break;
                                }
                                case BYTE: {
                                    binder.bind(Key.get(Byte.class, (Annotation)((Object)n))).toProvider((Provider)new ByteProvider(p));
                                    break;
                                }
                                case CHARACTER: {
                                    binder.bind(Key.get(Character.class, (Annotation)((Object)n))).toProvider((Provider)new CharacterProvider(p));
                                    break;
                                }
                                case DOUBLE: {
                                    binder.bind(Key.get(Double.class, (Annotation)((Object)n))).toProvider((Provider)new DoubleProvider(p));
                                    break;
                                }
                                case FLOAT: {
                                    binder.bind(Key.get(Float.class, (Annotation)((Object)n))).toProvider((Provider)new FloatProvider(p));
                                    break;
                                }
                                case SHORT: {
                                    binder.bind(Key.get(Short.class, (Annotation)((Object)n))).toProvider((Provider)new ShortProvider(p));
                                    break;
                                }
                                case BIG_DECIMAL: {
                                    binder.bind(Key.get(BigDecimal.class, (Annotation)((Object)n))).toProvider((Provider)new BigDecimalProvider(p));
                                    break;
                                }
                                case BIG_INTEGER: {
                                    binder.bind(Key.get(BigInteger.class, (Annotation)((Object)n))).toProvider((Provider)new BigIntegerProvider(p));
                                    break;
                                }
                                case DURATION: {
                                    binder.bind(Key.get(Duration.class, (Annotation)((Object)n))).toProvider((Provider)new DurationProvider(p));
                                }
                            }
                        }
                    }
                }
                this.bind(Settings.class).toProvider((Provider)namespacedSettings);
                this.bind(MutableSettings.class).toProvider((Provider)new MutableSettingsProvider(namespacedSettings, currentType));
                boolean bl = isUsingNamespaces = knownNamespaces.size() > 1 || knownNamespaces.size() == 1 && !"defaults".equals(knownNamespaces.iterator().next());
                if (isUsingNamespaces) {
                    binder.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListenerImpl()});
                }
            }
            catch (IOException ioe) {
                throw new ConfigurationError((Throwable)ioe);
            }
        }

        private final class ProvisionListenerImpl
        implements ProvisionListener {
            ProvisionListenerImpl() {
            }

            public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                TypeLiteral old = (TypeLiteral)currentType.get();
                prevType.set((Object)old);
                try (QuietAutoClosable pc = prevType.setTo((Object)((TypeLiteral)currentType.get()));
                     QuietAutoClosable ac = currentType.setTo((Object)provision.getBinding().getKey().getTypeLiteral());){
                    Object object = provision.provision();
                }
            }
        }
    }

    private static class DurationProvider
    implements Provider<Duration> {
        private final Provider<String> p;

        public DurationProvider(Provider<String> p) {
            this.p = p;
        }

        public Duration get() {
            String s = (String)this.p.get();
            if (s == null) {
                return null;
            }
            return TimeUtil.parseDuration((String)s);
        }
    }

    private static class BigIntegerProvider
    implements Provider<BigInteger> {
        private final Provider<String> p;

        BigIntegerProvider(Provider<String> p) {
            this.p = p;
        }

        public BigInteger get() {
            String s = (String)this.p.get();
            return s == null ? null : new BigInteger(s);
        }
    }

    private static class BigDecimalProvider
    implements Provider<BigDecimal> {
        private final Provider<String> p;

        BigDecimalProvider(Provider<String> p) {
            this.p = p;
        }

        public BigDecimal get() {
            String s = (String)this.p.get();
            return s == null ? null : new BigDecimal(s);
        }
    }

    private static class PropertyProvider
    implements Provider<String> {
        private final String key;
        private final Provider<Settings> props;

        PropertyProvider(String key, Provider<Settings> props) {
            this.key = key;
            this.props = props;
        }

        public String get() {
            return ((Settings)this.props.get()).getString(this.key);
        }
    }

    private static class BooleanProvider
    implements Provider<Boolean> {
        private final Provider<String> p;

        BooleanProvider(Provider<String> p) {
            this.p = p;
        }

        public Boolean get() {
            String s = (String)this.p.get();
            return s == null ? false : Boolean.valueOf(s);
        }
    }

    private static class IntProvider
    implements Provider<Integer> {
        private final Provider<String> p;

        IntProvider(Provider<String> p) {
            this.p = p;
        }

        public Integer get() {
            String s = (String)this.p.get();
            return s == null ? null : Integer.valueOf(Integer.parseInt(s));
        }
    }

    private static class LongProvider
    implements Provider<Long> {
        private final Provider<String> p;

        LongProvider(Provider<String> p) {
            this.p = p;
        }

        public Long get() {
            String s = (String)this.p.get();
            return s == null ? null : Long.valueOf(Long.parseLong(s));
        }
    }

    private static class CharacterProvider
    implements Provider<Character> {
        private final Provider<String> p;

        CharacterProvider(Provider<String> p) {
            this.p = p;
        }

        public Character get() {
            String s = (String)this.p.get();
            return s == null ? null : Character.valueOf(s.length() == 0 ? (char)'\u0000' : s.charAt(0));
        }
    }

    private static class ShortProvider
    implements Provider<Short> {
        private final Provider<String> p;

        ShortProvider(Provider<String> p) {
            this.p = p;
        }

        public Short get() {
            String s = (String)this.p.get();
            return s == null ? null : Short.valueOf(Short.parseShort(s));
        }
    }

    private static class DoubleProvider
    implements Provider<Double> {
        private final Provider<String> p;

        DoubleProvider(Provider<String> p) {
            this.p = p;
        }

        public Double get() {
            String s = (String)this.p.get();
            return s == null ? null : Double.valueOf(Double.parseDouble(s));
        }
    }

    private static class FloatProvider
    implements Provider<Float> {
        private final Provider<String> p;

        FloatProvider(Provider<String> p) {
            this.p = p;
        }

        public Float get() {
            String s = (String)this.p.get();
            return s == null ? null : Float.valueOf(Float.parseFloat(s));
        }
    }

    private static class ByteProvider
    implements Provider<Byte> {
        private final Provider<String> p;

        ByteProvider(Provider<String> p) {
            this.p = p;
        }

        public Byte get() {
            String s = (String)this.p.get();
            return s == null ? null : Byte.valueOf(Byte.parseByte(s));
        }
    }

    private static class NamespacedSettingsProvider
    implements Provider<Settings> {
        private final Dependencies deps;
        static volatile Method getDefinedPackageMethod;
        static boolean checkedGetDefinedPackageMethod;

        NamespacedSettingsProvider(Dependencies deps) {
            this.deps = deps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Method lookupGetDefinedPackageMethod() {
            if (getDefinedPackageMethod != null) {
                return getDefinedPackageMethod;
            }
            if (checkedGetDefinedPackageMethod) {
                return null;
            }
            Method result = null;
            try {
                result = ClassLoader.class.getDeclaredMethod("getDefinedPackage", String.class);
                Class<NamespacedSettingsProvider> clazz = NamespacedSettingsProvider.class;
                synchronized (NamespacedSettingsProvider.class) {
                    getDefinedPackageMethod = result;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception ex) {
                Logger.getLogger(Dependencies.class.getName()).log(Level.FINE, "Check availability of JDK 9's ClassLoader.getDefinedPackage()", ex);
            }
            finally {
                checkedGetDefinedPackageMethod = true;
            }
            {
                return result;
            }
        }

        private Package jdk9getPackage(String pkg) {
            Method mth = NamespacedSettingsProvider.lookupGetDefinedPackageMethod();
            if (mth != null) {
                ClassLoader ldr = Thread.currentThread().getContextClassLoader();
                try {
                    return (Package)mth.invoke((Object)ldr, pkg);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(Dependencies.class.getName()).log(Level.FINE, "Invoking ClassLoader.getDefinedPackage(\"" + pkg + "\")", ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(Dependencies.class.getName()).log(Level.FINE, "Invoking ClassLoader.getDefinedPackage(\"" + pkg + "\")", ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(Dependencies.class.getName()).log(Level.FINE, "Invoking ClassLoader.getDefinedPackage(\"" + pkg + "\")", ex);
                }
            }
            return null;
        }

        private static Package reflectivePackageGetPackage(String what) {
            StringBuilder sb = new StringBuilder("j").append("ava.lang");
            String mth = "getPackage";
            sb.append(".Package");
            try {
                Class<?> cl = Class.forName(sb.toString());
                Method method = cl.getMethod(mth, String.class);
                return (Package)method.invoke(null, what);
            }
            catch (Error | Exception ex) {
                Logger.getLogger(Dependencies.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        public Settings get() {
            TypeLiteral t = (TypeLiteral)prevType.get();
            String namespace = "defaults";
            if (t != null) {
                Package pkg;
                Class type = t.getRawType();
                Namespace ns = type.getAnnotation(Namespace.class);
                if (ns == null && (pkg = type.getPackage()) != null) {
                    do {
                        if ((ns = pkg.getAnnotation(Namespace.class)) != null) continue;
                        String nm = pkg.getName();
                        Matcher m = PARENT_PACKAGE_PATTERN.matcher(nm);
                        if (!m.find()) break;
                        pkg = this.jdk9getPackage(m.group(1));
                        if (pkg == null) {
                            pkg = NamespacedSettingsProvider.reflectivePackageGetPackage(m.group(1));
                        }
                        if (pkg == null || pkg.getName().isEmpty()) break;
                    } while (ns == null);
                }
                if (ns != null) {
                    namespace = ns.value();
                }
            }
            Dependencies.log("INJECTING INTO " + t + " WITH NAMESPACE " + namespace);
            Settings s = (Settings)this.deps.settings.get(namespace);
            return s;
        }
    }

    private static class MutableSettingsProvider
    implements Provider<MutableSettings> {
        private final Provider<Settings> namespaced;
        private final ThreadLocalValue<?> injectingInto;
        private static Set<String> WARNED = new HashSet<String>();

        MutableSettingsProvider(Provider<Settings> namespaced, ThreadLocalValue<?> injectingInto) {
            this.namespaced = namespaced;
            this.injectingInto = injectingInto;
        }

        public MutableSettings get() {
            Settings result = (Settings)this.namespaced.get();
            if (result instanceof MutableSettings) {
                return (MutableSettings)result;
            }
            try {
                String toWarn;
                Object warnAbout = this.injectingInto.get();
                if (warnAbout != null && !WARNED.contains(toWarn = warnAbout.toString())) {
                    WARNED.add(toWarn);
                    System.out.println(this.injectingInto.get() + " is requesting MutableSettings, but none was bound.  Creating ephemeral settings, but probably nothing but the object it is injected into will see changes in it.");
                }
                return new SettingsBuilder().add(result).buildMutableSettings();
            }
            catch (IOException ex) {
                return (MutableSettings)Exceptions.chuck((Throwable)ex);
            }
        }
    }

    private static final class ValueImpl
    implements Value {
        private final Namespace ns;
        private final String key;

        ValueImpl(String key, String ns) {
            this.ns = new NamespaceImpl(ns);
            this.key = key;
        }

        public String toString() {
            return this.ns + "::" + this.key;
        }

        public String value() {
            return this.key;
        }

        public Namespace namespace() {
            return this.ns;
        }

        public Class<? extends Annotation> annotationType() {
            return Value.class;
        }

        public int hashCode() {
            int result = 127 * "value".hashCode() ^ this.key.hashCode();
            return result += 127 * "namespace".hashCode() ^ this.ns.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueImpl other = (ValueImpl)obj;
            if (!Objects.equals(this.ns, other.ns)) {
                return false;
            }
            return Objects.equals(this.key, other.key);
        }
    }

    private static class NamespaceImpl
    implements Namespace {
        private final String name;

        NamespaceImpl(String name) {
            this.name = name;
        }

        public String value() {
            return this.name;
        }

        public Class<? extends Annotation> annotationType() {
            return Namespace.class;
        }

        public String toString() {
            return "Namespace('" + this.name + "')";
        }

        public boolean equals(Object o) {
            return o instanceof Namespace && this.name.equals(((Namespace)o).value());
        }

        public int hashCode() {
            int result = 127 * "value".hashCode() ^ this.name.hashCode();
            return result;
        }
    }
}

