/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius;

import com.google.common.collect.Maps;
import com.google.inject.Module;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.SettingsBindings;
import com.mastfrog.settings.Settings;
import com.mastfrog.settings.SettingsBuilder;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.ConfigurationError;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DependenciesBuilder {
    private final Map<String, List<SettingsBuilder>> settingsForNamespace = Maps.newHashMapWithExpectedSize((int)5);
    private final List<Module> modules = new LinkedList<Module>();
    private final Set<File> locations = new LinkedHashSet<File>();
    private long shutdownHookExecutorWaitMillis;
    private final Set<SettingsBindings> settingsBindings = EnumSet.allOf(SettingsBindings.class);
    private boolean useMutableSettings;
    private boolean mergeNamespaces;

    public Set<String> namespaces() {
        return new HashSet<String>(this.settingsForNamespace.keySet());
    }

    public DependenciesBuilder withShutdownHookExecutorAwaitDuration(Duration dur) {
        this.shutdownHookExecutorWaitMillis = dur.toMillis();
        return this;
    }

    public DependenciesBuilder withMinimumShutdownHookExecutorAwaitDuration(Duration dur) {
        this.shutdownHookExecutorWaitMillis = Math.max(dur.toMillis(), this.shutdownHookExecutorWaitMillis);
        return this;
    }

    public DependenciesBuilder add(Module ... modules) {
        Checks.notNull((String)"modules", (Object)modules);
        this.modules.addAll(Arrays.asList(modules));
        return this;
    }

    public DependenciesBuilder addDefaultLocation(File loc) {
        if (loc.exists() && !loc.isDirectory()) {
            throw new ConfigurationError("Not a directory: " + loc);
        }
        this.locations.add(loc);
        return this;
    }

    public DependenciesBuilder disableBindings(SettingsBindings ... bindings) {
        EnumSet<SettingsBindings> toRemove = EnumSet.noneOf(SettingsBindings.class);
        toRemove.addAll(Arrays.asList(bindings));
        this.settingsBindings.removeAll(toRemove);
        return this;
    }

    public DependenciesBuilder enableOnlyBindingsFor(SettingsBindings ... bindings) {
        EnumSet<SettingsBindings> newSet = EnumSet.noneOf(SettingsBindings.class);
        newSet.addAll(Arrays.asList(bindings));
        this.settingsBindings.clear();
        this.settingsBindings.addAll(newSet);
        return this;
    }

    private void addLocations(SettingsBuilder sb) {
        for (File loc : this.locations) {
            sb.addLocation(loc);
        }
    }

    public DependenciesBuilder addNamespace(String name) throws IOException {
        SettingsBuilder sb;
        if (!this.settingsForNamespace.containsKey(name)) {
            File home = new File(System.getProperty("user.home"));
            File f = new File(home, name + ".properties");
            sb = new SettingsBuilder(name).addEnv().addSystemProperties().addGeneratedDefaultsFromClasspath().addDefaultsFromClasspath();
            if (f.exists()) {
                sb.add(f);
            }
        } else {
            throw new IllegalArgumentException("Already added '" + name + "'");
        }
        this.addLocations(sb);
        this.add(sb.build(), name);
        return this;
    }

    public DependenciesBuilder addDefaultSettings() throws IOException {
        HashSet<String> namespaces = new HashSet<String>(this.settingsForNamespace.keySet());
        namespaces.addAll(Dependencies.loadNamespaceListsFromClasspath());
        namespaces.add("defaults");
        for (String ns : namespaces) {
            Settings s;
            SettingsBuilder sb;
            if ("defaults".equals(ns)) {
                sb = new SettingsBuilder().addDefaultLocations();
                this.addLocations(sb);
                s = sb.build();
            } else {
                sb = new SettingsBuilder(ns).addDefaultLocations();
                this.addLocations(sb);
                s = sb.build();
            }
            this.add(s, ns);
        }
        return this;
    }

    public List<SettingsBuilder> getSettings(String ns) {
        return this.settingsForNamespace.get(ns);
    }

    public DependenciesBuilder add(Settings settings) {
        return this.add(settings, "defaults");
    }

    public DependenciesBuilder add(Settings settings, String namespace) {
        Checks.notNull((String)"settings", (Object)settings);
        Checks.notNull((String)"namespace", (Object)namespace);
        Checks.notEmpty((String)"namespace", (CharSequence)namespace);
        List<SettingsBuilder> l = this.settingsForNamespace.get(namespace);
        if (l == null) {
            l = new LinkedList<SettingsBuilder>();
            this.settingsForNamespace.put(namespace, l);
        }
        SettingsBuilder sb = new SettingsBuilder(namespace).add(settings);
        l.add(sb);
        return this;
    }

    public DependenciesBuilder useMutableSettings() {
        this.useMutableSettings = true;
        return this;
    }

    public DependenciesBuilder mergeNamespaces() {
        this.mergeNamespaces = true;
        return this;
    }

    private Map<String, Settings> collapse() throws IOException {
        HashMap<String, Settings> result = new HashMap<String, Settings>();
        for (Map.Entry<String, List<SettingsBuilder>> e : this.settingsForNamespace.entrySet()) {
            if (e.getValue().size() == 1) {
                result.put(e.getKey(), e.getValue().iterator().next().build());
                continue;
            }
            SettingsBuilder sb = new SettingsBuilder(e.getKey());
            for (SettingsBuilder s : e.getValue()) {
                sb.add(s);
            }
            if (this.useMutableSettings) {
                result.put(e.getKey(), (Settings)sb.buildMutableSettings());
                continue;
            }
            result.put(e.getKey(), sb.build());
        }
        return result;
    }

    public Dependencies build() throws IOException {
        Dependencies result = new Dependencies(this.mergeNamespaces, this.collapse(), this.settingsBindings, this.modules.toArray(new Module[this.modules.size()]));
        result.setShutdownHookExecutorWaitMillis(this.shutdownHookExecutorWaitMillis);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MODULES:\n");
        for (Module m : this.modules) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(m).append('\n');
        }
        sb.append("NAMESPACES:\n");
        for (String ns : this.settingsForNamespace.keySet()) {
            sb.append(ns).append(',');
        }
        sb.append("\n");
        for (String ns : this.settingsForNamespace.keySet()) {
            sb.append(ns).append(": ").append("\n").append("  ").append(this.settingsForNamespace.get(ns)).append("\n");
        }
        return sb.toString();
    }
}

