/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Retention(value=RetentionPolicy.RUNTIME)
public @interface Ordered {
    public int value();

    public static final class OrderedObjectComparator
    implements Comparator<Object> {
        private final OrderedTypeComparator typeComparator = new OrderedTypeComparator();

        @Override
        public int compare(Object a, Object b) {
            if (a == null && b != null) {
                return 1;
            }
            if (a != null && b == null) {
                return -1;
            }
            if (a == null && b == null) {
                return 0;
            }
            return this.typeComparator.compare(a.getClass(), b.getClass());
        }
    }

    public static final class OrderedTypeComparator
    implements Comparator<Class<?>> {
        private static final Set<String> WARNED_CLASSES = new HashSet<String>();

        private void warn(Class<?> type) {
            boolean asserts = false;
            if (!$assertionsDisabled) {
                asserts = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (!asserts) {
                return;
            }
            if (!WARNED_CLASSES.contains(type.getName())) {
                Logger.getLogger(OrderedTypeComparator.class.getName()).log(Level.WARNING, "{0} does not specify the @Ordered annotation", type.getName());
                WARNED_CLASSES.add(type.getName());
            }
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            int p2;
            Ordered pos1 = o1.getAnnotation(Ordered.class);
            Ordered pos2 = o2.getAnnotation(Ordered.class);
            if (pos1 == null && pos2 != null) {
                this.warn(o1);
                return 1;
            }
            if (pos1 != null && pos2 == null) {
                this.warn(o2);
                return -1;
            }
            if (pos1 == null) {
                this.warn(o1);
                this.warn(o2);
                return 0;
            }
            int p1 = pos1.value();
            return p1 == (p2 = pos2.value()) ? 0 : (p1 > p2 ? 1 : -1);
        }
    }
}

