/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class TypeUtils {
    public static <S, T> ParameterizedType generifiedType(Class<S> outerType, Class<T> typeParameter) {
        return new OneGenericFakeType<S, T>(outerType, typeParameter);
    }

    public static <S, T, U> ParameterizedType generifiedType(Class<S> outerType, Class<T> typeParameter, Class<U> typeParameter2) {
        return new TwoGenericFakeType<S, T, U>(outerType, typeParameter, typeParameter2);
    }

    public static <S, T, U, V> ParameterizedType generifiedType(Class<S> outerType, Class<T> typeParameter, Class<U> typeParameter2, Class<V> typeParameter3) {
        return new ThreeGenericFakeType<S, T, U, V>(outerType, typeParameter, typeParameter2, typeParameter3);
    }

    private TypeUtils() {
    }

    private static final class OneGenericFakeType<R, T>
    implements ParameterizedType {
        private final Class<T> genericType;
        private final Class<R> topType;

        public OneGenericFakeType(Class<R> topType, Class<T> genericType) {
            this.topType = topType;
            this.genericType = genericType;
        }

        @Override
        public String getTypeName() {
            return this.topType.getName();
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.genericType};
        }

        @Override
        public Type getRawType() {
            return this.topType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        public String toString() {
            return this.topType.getSimpleName() + '<' + this.genericType.getSimpleName() + '>';
        }
    }

    private static final class TwoGenericFakeType<R, T, U>
    implements ParameterizedType {
        private final Class<T> genericType;
        private final Class<R> topType;
        private final Class<U> otherGenericType;

        public TwoGenericFakeType(Class<R> topType, Class<T> genericType, Class<U> otherGenericType) {
            this.topType = topType;
            this.genericType = genericType;
            this.otherGenericType = otherGenericType;
        }

        @Override
        public String getTypeName() {
            return this.topType.getName();
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.genericType, this.otherGenericType};
        }

        @Override
        public Type getRawType() {
            return this.topType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        public String toString() {
            return this.topType.getSimpleName() + '<' + this.genericType.getSimpleName() + ", " + this.otherGenericType.getSimpleName() + '>';
        }
    }

    private static final class ThreeGenericFakeType<R, T, U, V>
    implements ParameterizedType {
        private final Class<T> genericType;
        private final Class<R> topType;
        private final Class<U> otherGenericType;
        private final Class<V> otherOtherGenericType;

        public ThreeGenericFakeType(Class<R> topType, Class<T> genericType, Class<U> otherGenericType, Class<V> otherOtherGenericType) {
            this.topType = topType;
            this.genericType = genericType;
            this.otherGenericType = otherGenericType;
            this.otherOtherGenericType = otherOtherGenericType;
        }

        @Override
        public String getTypeName() {
            return this.topType.getName();
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.genericType, this.otherGenericType, this.otherOtherGenericType};
        }

        @Override
        public Type getRawType() {
            return this.topType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        public String toString() {
            return this.topType.getSimpleName() + '<' + this.genericType.getSimpleName() + ", " + this.otherGenericType.getSimpleName() + ", " + this.otherOtherGenericType.getSimpleName() + '>';
        }
    }
}

