/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.jackson.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mastfrog.jackson.configuration.DurationSerializationMode;
import com.mastfrog.jackson.configuration.TimeSerializationMode;
import com.mastfrog.jackson.configuration.impl.JavaOptionalSerializer;
import com.mastfrog.jackson.configuration.impl.JavaTimeConfigurer;
import com.mastfrog.jackson.configuration.impl.LocaleJacksonConfigurer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;

public interface JacksonConfigurer
extends Comparable<JacksonConfigurer> {
    public ObjectMapper configure(ObjectMapper var1);

    default public int precedence() {
        return 0;
    }

    default public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    default public int compareTo(JacksonConfigurer o) {
        return Integer.compare(this.precedence(), o.precedence());
    }

    public static JacksonConfigurer javaTimeConfigurer() {
        return new JavaTimeConfigurer(TimeSerializationMode.TIME_AS_ISO_STRING, DurationSerializationMode.DURATION_AS_ISO_STRING);
    }

    public static JacksonConfigurer javaTimeConfigurer(TimeSerializationMode timeMode, DurationSerializationMode durationMode) {
        return new JavaTimeConfigurer(timeMode, durationMode);
    }

    public static JacksonConfigurer localeConfigurer() {
        return new LocaleJacksonConfigurer();
    }

    public static JacksonConfigurer optionalSerializer() {
        return new JavaOptionalSerializer();
    }

    public static Collection<? extends JacksonConfigurer> metaInfServices() {
        ArrayList<JacksonConfigurer> all = new ArrayList<JacksonConfigurer>(10);
        for (JacksonConfigurer c : ServiceLoader.load(JacksonConfigurer.class)) {
            all.add(c);
        }
        return all;
    }

    public static ObjectMapper configureFromMetaInfServices(ObjectMapper orig) {
        return JacksonConfigurer.apply(orig, JacksonConfigurer.metaInfServices());
    }

    public static ObjectMapper apply(ObjectMapper mapper, Iterable<? extends JacksonConfigurer> configs) {
        for (JacksonConfigurer jacksonConfigurer : configs) {
            mapper = jacksonConfigurer.configure(mapper);
        }
        return mapper;
    }

    public static ObjectMapper apply(ObjectMapper mapper, JacksonConfigurer ... configs) {
        for (JacksonConfigurer cf : configs) {
            mapper = cf.configure(mapper);
        }
        return mapper;
    }
}

