/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.jackson.configuration.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mastfrog.jackson.configuration.JacksonConfigurer;
import java.io.IOException;
import java.util.Optional;

public class JavaOptionalSerializer
implements JacksonConfigurer {
    @Override
    public ObjectMapper configure(ObjectMapper mapper) {
        SimpleModule sm = new SimpleModule("java-optional", new Version(1, 0, 0, null, "com.mastfrog", "com-google-common-base-optional"));
        sm.addSerializer((JsonSerializer)new OptionalSer());
        mapper.registerModule((Module)sm);
        return mapper;
    }

    @Override
    public int precedence() {
        return 0;
    }

    public String toString() {
        return "JavaOptionalSerializer";
    }

    private static final class OptionalSer
    extends JsonSerializer<Optional> {
        private OptionalSer() {
        }

        public Class<Optional> handledType() {
            return Optional.class;
        }

        public void serialize(Optional t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            if (t.isPresent()) {
                sp.defaultSerializeValue(t.get(), jg);
            } else {
                jg.writeNull();
            }
        }
    }
}

